/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.spec.ExcC14NParameterSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.DOMCallbackLookup;
import org.apache.ws.security.message.WSSecBase;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSSecSignatureBase
extends WSSecBase {
    private static Log log = LogFactory.getLog(WSSecSignatureBase.class);

    public WSSecSignatureBase() {
    }

    public WSSecSignatureBase(WSSConfig config) {
        super(config);
    }

    public List<Reference> addReferencesToSign(Document doc, List<WSEncryptionPart> references, WSDocInfo wsDocInfo, XMLSignatureFactory signatureFactory, WSSecHeader secHeader, WSSConfig wssConfig, String digestAlgo) throws WSSecurityException {
        DigestMethod digestMethod;
        try {
            digestMethod = signatureFactory.newDigestMethod(digestAlgo, null);
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            throw new WSSecurityException(10, "noXMLSig", null, ex);
        }
        ArrayList<Reference> referenceList = new ArrayList<Reference>();
        for (WSEncryptionPart encPart : references) {
            String idToSign = encPart.getId();
            String elemName = encPart.getName();
            Element element = encPart.getElement();
            try {
                if (idToSign != null) {
                    Transform transform = null;
                    if ("STRTransform".equals(elemName)) {
                        Element ctx = this.createSTRParameter(doc);
                        DOMStructure structure = new DOMStructure(ctx);
                        transform = signatureFactory.newTransform("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform", structure);
                    } else {
                        ExcC14NParameterSpec transformSpec = null;
                        if (wssConfig.isWsiBSPCompliant()) {
                            Element toSignById = element;
                            if (toSignById == null) {
                                if (this.callbackLookup == null) {
                                    this.callbackLookup = new DOMCallbackLookup(doc);
                                }
                                toSignById = this.callbackLookup.getElement(idToSign, null, false);
                                wsDocInfo.addProtectionElement(toSignById);
                            }
                            List<String> prefixes = this.getInclusivePrefixes(toSignById);
                            transformSpec = new ExcC14NParameterSpec(prefixes);
                        }
                        transform = signatureFactory.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", transformSpec);
                    }
                    if (element != null) {
                        wsDocInfo.addProtectionElement(element);
                    }
                    Reference reference = signatureFactory.newReference("#" + idToSign, digestMethod, Collections.singletonList(transform), null, null);
                    referenceList.add(reference);
                    continue;
                }
                String nmSpace = encPart.getNamespace();
                List<Element> elementsToSign = null;
                if (element != null) {
                    elementsToSign = Collections.singletonList(element);
                } else {
                    if (this.callbackLookup == null) {
                        this.callbackLookup = new DOMCallbackLookup(doc);
                    }
                    elementsToSign = WSSecurityUtil.findElements(encPart, this.callbackLookup, doc);
                }
                if (elementsToSign == null || elementsToSign.size() == 0) {
                    throw new WSSecurityException(0, "noEncElement", new Object[]{nmSpace + ", " + elemName});
                }
                for (Element elementToSign : elementsToSign) {
                    wsDocInfo.addProtectionElement(elementToSign);
                    ExcC14NParameterSpec transformSpec = null;
                    if (wssConfig.isWsiBSPCompliant()) {
                        List<String> prefixes = this.getInclusivePrefixes(elementToSign);
                        transformSpec = new ExcC14NParameterSpec(prefixes);
                    }
                    Transform transform = signatureFactory.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", transformSpec);
                    Reference reference = signatureFactory.newReference("#" + this.setWsuId(elementToSign), digestMethod, Collections.singletonList(transform), null, null);
                    referenceList.add(reference);
                }
            }
            catch (Exception ex) {
                log.error((Object)"", (Throwable)ex);
                throw new WSSecurityException(10, "noXMLSig", null, ex);
            }
        }
        return referenceList;
    }

    public List<String> getInclusivePrefixes(Element target) {
        return this.getInclusivePrefixes(target, true);
    }

    public List<String> getInclusivePrefixes(Element target, boolean excludeVisible) {
        Node attribute;
        int i;
        NamedNodeMap attributes;
        ArrayList<String> result = new ArrayList<String>();
        Node parent = target;
        while (parent.getParentNode() != null && 9 != parent.getParentNode().getNodeType()) {
            parent = parent.getParentNode();
            attributes = parent.getAttributes();
            for (i = 0; i < attributes.getLength(); ++i) {
                attribute = attributes.item(i);
                if (!"http://www.w3.org/2000/xmlns/".equals(attribute.getNamespaceURI())) continue;
                if ("xmlns".equals(attribute.getNodeName())) {
                    result.add("#default");
                    continue;
                }
                result.add(attribute.getLocalName());
            }
        }
        if (excludeVisible) {
            attributes = target.getAttributes();
            for (i = 0; i < attributes.getLength(); ++i) {
                attribute = attributes.item(i);
                if ("http://www.w3.org/2000/xmlns/".equals(attribute.getNamespaceURI())) {
                    if ("xmlns".equals(attribute.getNodeName())) {
                        result.remove("#default");
                    } else {
                        result.remove(attribute.getLocalName());
                    }
                }
                if (attribute.getPrefix() == null) continue;
                result.remove(attribute.getPrefix());
            }
            if (target.getPrefix() == null) {
                result.remove("#default");
            } else {
                result.remove(target.getPrefix());
            }
        }
        return result;
    }

    public Element createSTRParameter(Document doc) {
        Element transformParam = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:TransformationParameters");
        Element canonElem = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:CanonicalizationMethod");
        canonElem.setAttributeNS(null, "Algorithm", "http://www.w3.org/2001/10/xml-exc-c14n#");
        transformParam.appendChild(canonElem);
        return transformParam;
    }
}

