/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.api.metadata.ds;

import java.util.HashMap;
import java.util.Map;
import org.jboss.jca.common.api.metadata.common.CommonXaPool;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.ds.CommonDataSource;
import org.jboss.jca.common.api.metadata.ds.Statement;

public interface XaDataSource
extends CommonDataSource {
    public String getXaDataSourceClass();

    public Statement getStatement();

    public String getUrlDelimiter();

    public String getUrlSelectorStrategyClassName();

    public String getNewConnectionSql();

    public Map<String, String> getXaDataSourceProperty();

    public CommonXaPool getXaPool();

    public Recovery getRecovery();

    public static enum Attribute {
        JNDINAME("jndi-name"),
        POOL_NAME("pool-name"),
        ENABLED("enabled"),
        USEJAVACONTEXT("use-java-context"),
        SPY("spy"),
        USE_CCM("use-ccm");

        private final String name;

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }
    }

    public static enum Tag {
        UNKNOWN(null),
        XADATASOURCEPROPERTY("xa-datasource-property"),
        XADATASOURCECLASS("xa-datasource-class"),
        DRIVER("driver"),
        TRANSACTIONISOLATION("transaction-isolation"),
        TIMEOUT("timeout"),
        SECURITY("security"),
        STATEMENT("statement"),
        VALIDATION("validation"),
        URLDELIMITER("url-delimiter"),
        URLSELECTORSTRATEGYCLASSNAME("url-selector-strategy-class-name"),
        NEWCONNECTIONSQL("new-connection-sql"),
        XA_POOL("xa-pool"),
        RECOVERY("recovery");

        private final String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

