/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.impl;

import java.util.concurrent.ScheduledExecutorService;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.paging.cursor.PageSubscription;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.QueueFactory;
import org.hornetq.core.server.impl.LastValueQueue;
import org.hornetq.core.server.impl.QueueImpl;
import org.hornetq.core.settings.HierarchicalRepository;
import org.hornetq.core.settings.impl.AddressSettings;
import org.hornetq.utils.ExecutorFactory;

public class QueueFactoryImpl
implements QueueFactory {
    private final HierarchicalRepository<AddressSettings> addressSettingsRepository;
    private final ScheduledExecutorService scheduledExecutor;
    private PostOffice postOffice;
    private final StorageManager storageManager;
    private final ExecutorFactory executorFactory;

    public QueueFactoryImpl(ExecutorFactory executorFactory, ScheduledExecutorService scheduledExecutor, HierarchicalRepository<AddressSettings> addressSettingsRepository, StorageManager storageManager) {
        this.addressSettingsRepository = addressSettingsRepository;
        this.scheduledExecutor = scheduledExecutor;
        this.storageManager = storageManager;
        this.executorFactory = executorFactory;
    }

    @Override
    public void setPostOffice(PostOffice postOffice) {
        this.postOffice = postOffice;
    }

    @Override
    public Queue createQueue(long persistenceID, SimpleString address, SimpleString name, Filter filter, PageSubscription pageSubscription, boolean durable, boolean temporary) {
        AddressSettings addressSettings = this.addressSettingsRepository.getMatch(address.toString());
        QueueImpl queue = addressSettings.isLastValueQueue() ? new LastValueQueue(persistenceID, address, name, filter, pageSubscription, durable, temporary, this.scheduledExecutor, this.postOffice, this.storageManager, this.addressSettingsRepository, this.executorFactory.getExecutor()) : new QueueImpl(persistenceID, address, name, filter, pageSubscription, durable, temporary, this.scheduledExecutor, this.postOffice, this.storageManager, this.addressSettingsRepository, this.executorFactory.getExecutor());
        return queue;
    }
}

