/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.journal.impl;

import java.nio.ByteBuffer;
import org.hornetq.core.journal.SequentialFile;
import org.hornetq.core.journal.SequentialFileFactory;
import org.hornetq.core.journal.impl.AbstractSequentialFileFactory;
import org.hornetq.core.journal.impl.NIOSequentialFile;
import org.hornetq.core.logging.Logger;

public class NIOSequentialFileFactory
extends AbstractSequentialFileFactory
implements SequentialFileFactory {
    private static final Logger log = Logger.getLogger(NIOSequentialFileFactory.class);

    public NIOSequentialFileFactory(String journalDir) {
        this(journalDir, false, 501760, 3333333, false);
    }

    public NIOSequentialFileFactory(String journalDir, boolean buffered) {
        this(journalDir, buffered, 501760, 3333333, false);
    }

    public NIOSequentialFileFactory(String journalDir, boolean buffered, int bufferSize, int bufferTimeout, boolean logRates) {
        super(journalDir, buffered, bufferSize, bufferTimeout, logRates);
    }

    @Override
    public SequentialFile createSequentialFile(String fileName, int maxIO) {
        if (maxIO < 1) {
            maxIO = 1;
        }
        return new NIOSequentialFile(this, this.journalDir, fileName, maxIO, this.writeExecutor);
    }

    @Override
    public boolean isSupportsCallbacks() {
        return this.timedBuffer != null;
    }

    @Override
    public ByteBuffer newBuffer(int size) {
        return ByteBuffer.allocate(size);
    }

    @Override
    public void clearBuffer(ByteBuffer buffer) {
        int limit = buffer.limit();
        buffer.rewind();
        for (int i = 0; i < limit; ++i) {
            buffer.put((byte)0);
        }
        buffer.rewind();
    }

    @Override
    public ByteBuffer wrapBuffer(byte[] bytes) {
        return ByteBuffer.wrap(bytes);
    }

    @Override
    public int getAlignment() {
        return 1;
    }

    @Override
    public int calculateBlockSize(int bytes) {
        return bytes;
    }
}

