/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.config.impl;

import org.hornetq.core.server.JournalType;
import org.hornetq.core.settings.impl.AddressFullMessagePolicy;

public final class Validators {
    public static final Validator NO_CHECK = new Validator(){

        @Override
        public void validate(String name, Object value) {
        }
    };
    public static final Validator NOT_NULL_OR_EMPTY = new Validator(){

        @Override
        public void validate(String name, Object value) {
            String str = (String)value;
            if (str == null || str.length() == 0) {
                throw new IllegalArgumentException(String.format("%s must neither be null nor empty", name));
            }
        }
    };
    public static final Validator GT_ZERO = new Validator(){

        @Override
        public void validate(String name, Object value) {
            Number val = (Number)value;
            if (!(val.doubleValue() > 0.0)) {
                throw new IllegalArgumentException(String.format("%s  must be greater than 0 (actual value: %s)", name, val));
            }
        }
    };
    public static final Validator PERCENTAGE = new Validator(){

        @Override
        public void validate(String name, Object value) {
            Number val = (Number)value;
            if (val != null && val.intValue() < 0 || val.intValue() > 100) {
                throw new IllegalArgumentException(String.format("%s  must be a valid percentual value between 0 and 100 (actual value: %s)", name, val));
            }
        }
    };
    public static final Validator GE_ZERO = new Validator(){

        @Override
        public void validate(String name, Object value) {
            Number val = (Number)value;
            if (!(val.doubleValue() >= 0.0)) {
                throw new IllegalArgumentException(String.format("%s  must be greater or equals than 0 (actual value: %s)", name, val));
            }
        }
    };
    public static final Validator MINUS_ONE_OR_GT_ZERO = new Validator(){

        @Override
        public void validate(String name, Object value) {
            Number val = (Number)value;
            if (val.doubleValue() != -1.0 && !(val.doubleValue() > 0.0)) {
                throw new IllegalArgumentException(String.format("%s  must be equals to -1 or greater than 0 (actual value: %s)", name, val));
            }
        }
    };
    public static final Validator MINUS_ONE_OR_GE_ZERO = new Validator(){

        @Override
        public void validate(String name, Object value) {
            Number val = (Number)value;
            if (val.doubleValue() != -1.0 && !(val.doubleValue() >= 0.0)) {
                throw new IllegalArgumentException(String.format("%s  must be equals to -1 or greater or equals to 0 (actual value: %s)", name, val));
            }
        }
    };
    public static final Validator THREAD_PRIORITY_RANGE = new Validator(){

        @Override
        public void validate(String name, Object value) {
            Number val = (Number)value;
            if (val.intValue() < 1 || val.intValue() > 10) {
                throw new IllegalArgumentException(String.format("%s must be betwen %s and %s inclusive (actual value: %s)", name, 1, 10, value));
            }
        }
    };
    public static final Validator JOURNAL_TYPE = new Validator(){

        @Override
        public void validate(String name, Object value) {
            String val = (String)value;
            if (val == null || !val.equals(JournalType.NIO.toString()) && !val.equals(JournalType.ASYNCIO.toString())) {
                throw new IllegalArgumentException("Invalid journal type " + val);
            }
        }
    };
    public static final Validator ADDRESS_FULL_MESSAGE_POLICY_TYPE = new Validator(){

        @Override
        public void validate(String name, Object value) {
            String val = (String)value;
            if (val == null || !val.equals(AddressFullMessagePolicy.PAGE.toString()) && !val.equals(AddressFullMessagePolicy.DROP.toString()) && !val.equals(AddressFullMessagePolicy.BLOCK.toString())) {
                throw new IllegalArgumentException("Invalid address full message policy type " + val);
            }
        }
    };

    public static interface Validator {
        public void validate(String var1, Object var2);
    }
}

