/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.config;

import java.io.Serializable;
import java.util.List;

public class ClusterConnectionConfiguration
implements Serializable {
    private static final long serialVersionUID = 8948303813427795935L;
    private final String name;
    private final String address;
    private final String connectorName;
    private final long retryInterval;
    private final boolean duplicateDetection;
    private final boolean forwardWhenNoConsumers;
    private final List<String> staticConnectors;
    private final String discoveryGroupName;
    private final int maxHops;
    private final int confirmationWindowSize;
    private final boolean allowDirectConnectionsOnly;

    public ClusterConnectionConfiguration(String name, String address, String connectorName, long retryInterval, boolean duplicateDetection, boolean forwardWhenNoConsumers, int maxHops, int confirmationWindowSize, List<String> staticConnectors, boolean allowDirectConnectionsOnly) {
        this.name = name;
        this.address = address;
        this.connectorName = connectorName;
        this.retryInterval = retryInterval;
        this.staticConnectors = staticConnectors;
        this.duplicateDetection = duplicateDetection;
        this.forwardWhenNoConsumers = forwardWhenNoConsumers;
        this.discoveryGroupName = null;
        this.maxHops = maxHops;
        this.confirmationWindowSize = confirmationWindowSize;
        this.allowDirectConnectionsOnly = allowDirectConnectionsOnly;
    }

    public ClusterConnectionConfiguration(String name, String address, String connectorName, long retryInterval, boolean duplicateDetection, boolean forwardWhenNoConsumers, int maxHops, int confirmationWindowSize, String discoveryGroupName) {
        this.name = name;
        this.address = address;
        this.connectorName = connectorName;
        this.retryInterval = retryInterval;
        this.duplicateDetection = duplicateDetection;
        this.forwardWhenNoConsumers = forwardWhenNoConsumers;
        this.discoveryGroupName = discoveryGroupName;
        this.staticConnectors = null;
        this.maxHops = maxHops;
        this.confirmationWindowSize = confirmationWindowSize;
        this.allowDirectConnectionsOnly = false;
    }

    public String getName() {
        return this.name;
    }

    public String getAddress() {
        return this.address;
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public boolean isDuplicateDetection() {
        return this.duplicateDetection;
    }

    public boolean isForwardWhenNoConsumers() {
        return this.forwardWhenNoConsumers;
    }

    public int getMaxHops() {
        return this.maxHops;
    }

    public int getConfirmationWindowSize() {
        return this.confirmationWindowSize;
    }

    public List<String> getStaticConnectors() {
        return this.staticConnectors;
    }

    public String getDiscoveryGroupName() {
        return this.discoveryGroupName;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public boolean isAllowDirectConnectionsOnly() {
        return this.allowDirectConnectionsOnly;
    }
}

