/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.integration.jbossas.vfs;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import org.jboss.seam.deployment.AbstractScanner;
import org.jboss.seam.deployment.DeploymentStrategy;
import org.jboss.seam.integration.jbossas.vfs.FileModifiableResource;
import org.jboss.seam.integration.jbossas.vfs.LeafVirtualFileFilter;
import org.jboss.seam.integration.jbossas.vfs.ModifiableResource;
import org.jboss.seam.integration.jbossas.vfs.VirtualFileModifiableResource;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

public class VFSScanner
extends AbstractScanner {
    protected final LogProvider log = Logging.getLogProvider(((Object)((Object)this)).getClass());
    protected static Method handleMethod;
    private long timestamp;

    public VFSScanner(DeploymentStrategy deploymentStrategy) {
        super(deploymentStrategy);
    }

    protected VirtualFile getRoot(URL url, int parentDepth) throws IOException {
        VirtualFile top;
        this.log.trace((Object)("Root url: " + url));
        try {
            top = VFS.getChild((URL)url);
        }
        catch (URISyntaxException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        while (parentDepth > 0) {
            if (top == null) {
                throw new IllegalArgumentException("Null parent: " + url + "Must have reached root VirtualFile");
            }
            top = top.getParent();
            --parentDepth;
        }
        this.log.trace((Object)("Top: " + top));
        return top;
    }

    public void scanDirectories(File[] directories) {
        this.scanDirectories(directories, new File[0]);
    }

    public void scanDirectories(File[] directories, File[] excludedDirectories) {
        for (File directory : directories) {
            this.handleDirectory(directory, null, excludedDirectories);
        }
    }

    private void handleDirectory(File file, String path, File[] excludedDirectories) {
        for (File excludedDirectory : excludedDirectories) {
            if (!file.equals(excludedDirectory)) continue;
            this.log.trace((Object)("Skipping excluded directory: " + file));
            return;
        }
        FileModifiableResource delegate = new FileModifiableResource();
        this.log.trace((Object)("Handling directory: " + file));
        for (File child : file.listFiles()) {
            String newPath;
            String string = newPath = path == null ? child.getName() : path + '/' + child.getName();
            if (child.isDirectory()) {
                this.handleDirectory(child, newPath, excludedDirectories);
                continue;
            }
            delegate.setFile(child);
            try {
                this.handleItem(delegate, newPath);
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
    }

    public void scanResources(String[] resources) {
        for (String resourceName : resources) {
            try {
                Enumeration<URL> urlEnum = this.getDeploymentStrategy().getClassLoader().getResources(resourceName);
                while (urlEnum.hasMoreElements()) {
                    URL url = urlEnum.nextElement();
                    VirtualFile root = this.getRoot(url, resourceName.lastIndexOf(47) > 0 ? 2 : 1);
                    if (root.exists()) {
                        this.handleRoot(root);
                        continue;
                    }
                    this.log.trace((Object)("Root does not exist: " + url));
                }
            }
            catch (IOException ioe) {
                this.log.warn((Object)("Cannot read resource: " + resourceName), (Throwable)ioe);
            }
        }
    }

    protected void handleRoot(VirtualFile root) throws IOException {
        VirtualFileModifiableResource delegate = new VirtualFileModifiableResource();
        if (root.isFile()) {
            delegate.setFile(root);
            this.touchTimestamp(delegate);
            this.handleItemIgnoreErrors(root.getPathName());
        } else {
            List children = root.getChildrenRecursively(LeafVirtualFileFilter.INSTANCE);
            for (VirtualFile child : children) {
                String path = child.getPathNameRelativeTo(root);
                delegate.setFile(child);
                this.handleItem(delegate, path);
            }
        }
    }

    protected void handleItem(ModifiableResource resource, String name) throws IOException {
        boolean doTouch = true;
        try {
            if (handleMethod != null) {
                doTouch = (Boolean)handleMethod.invoke((Object)this, name);
            }
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
        if (doTouch) {
            this.touchTimestamp(resource);
        }
        if (handleMethod == null) {
            this.handleItemIgnoreErrors(name);
        }
    }

    protected void handleItemIgnoreErrors(String name) {
        try {
            this.handleItem(name);
        }
        catch (Throwable t) {
            this.log.warn((Object)("Error handling item '" + name + "': " + t));
        }
    }

    private void touchTimestamp(ModifiableResource file) throws IOException {
        long lastModified = file.getLastModified();
        if (lastModified > this.timestamp) {
            this.timestamp = lastModified;
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    static {
        try {
            handleMethod = AbstractScanner.class.getDeclaredMethod("handle", String.class);
            handleMethod.setAccessible(true);
        }
        catch (Throwable t) {
            handleMethod = null;
        }
    }
}

