/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.framework;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.IOException;
import java.util.List;
import org.jboss.jsfunit.framework.SimpleInitialRequestStrategy;
import org.jboss.jsfunit.framework.WebClientSpec;

public class FormAuthenticationStrategy
extends SimpleInitialRequestStrategy {
    private String userName;
    private String password;
    private String userNameComponent = "j_username";
    private String passwordComponent = "j_password";
    private String submitComponent = "Submit";

    public FormAuthenticationStrategy(String userName, String password, String submitComponent) {
        this.userName = userName;
        this.password = password;
        this.submitComponent = submitComponent;
    }

    public FormAuthenticationStrategy(String userName, String password, String submitComponent, String userNameComponent, String passwordComponent) {
        this(userName, password, submitComponent);
        this.userNameComponent = userNameComponent;
        this.passwordComponent = passwordComponent;
    }

    public Page doInitialRequest(WebClientSpec wcSpec) throws IOException {
        HtmlPage page = (HtmlPage)super.doInitialRequest(wcSpec);
        this.setValue(page, this.userNameComponent, this.userName);
        this.setValue(page, this.passwordComponent, this.password);
        return this.clickSubmitComponent(page);
    }

    protected Page clickSubmitComponent(HtmlPage page) throws IOException {
        HtmlElement htmlElement = this.getElement(page, this.submitComponent);
        return htmlElement.click();
    }

    protected void setValue(HtmlPage page, String elementName, String value) {
        HtmlElement element = this.getElement(page, elementName);
        if (!(element instanceof HtmlInput)) {
            throw new IllegalStateException("Component with name=" + elementName + " is not an HtmlInput element.");
        }
        HtmlInput inputElement = (HtmlInput)element;
        inputElement.setValueAttribute(value);
    }

    protected HtmlElement getElement(HtmlPage page, String elementName) {
        List elements = page.getElementsByName(elementName);
        if (elements.size() == 0) {
            throw new IllegalStateException("Component with name=" + elementName + " was not found on the login page.");
        }
        if (elements.size() > 1) {
            throw new IllegalStateException("More than one component with name=" + elementName + " was found on the login page.");
        }
        return (HtmlElement)elements.get(0);
    }
}

