/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.embedded.ejb3;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.as.embedded.ejb3.ExclusionFilter;
import org.jboss.logging.Logger;
import org.jboss.vfs.VirtualFile;

public class BundleSymbolicNameExclusionFilter
implements ExclusionFilter {
    private static final Logger log = Logger.getLogger(BundleSymbolicNameExclusionFilter.class);
    private static final String HEADER_BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private static final String NAME_MANIFEST = "META-INF/MANIFEST.MF";
    private final Set<String> exclusionValues;

    public BundleSymbolicNameExclusionFilter(String ... exclusionValues) throws IllegalArgumentException {
        if (exclusionValues == null || exclusionValues.length == 0) {
            throw new IllegalArgumentException("one or more exclusion values must be specified");
        }
        HashSet<String> excludeSet = new HashSet<String>();
        for (String exclusionValue : exclusionValues) {
            excludeSet.add(exclusionValue);
        }
        this.exclusionValues = Collections.unmodifiableSet(excludeSet);
    }

    @Override
    public boolean exclude(VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("file must be specified");
        }
        if (!file.exists()) {
            return false;
        }
        VirtualFile manifest = file.getChild(NAME_MANIFEST);
        if (!manifest.exists()) {
            return false;
        }
        try {
            String line;
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(manifest.openStream()));
            while ((line = reader.readLine()) != null) {
                String header = HEADER_BUNDLE_SYMBOLIC_NAME;
                if (!line.contains(HEADER_BUNDLE_SYMBOLIC_NAME)) continue;
                for (String exclusionValue : this.exclusionValues) {
                    if (!line.contains(exclusionValue)) continue;
                    if (log.isTraceEnabled()) {
                        log.tracef("Configured exclusion value \"" + exclusionValue + "\" encountered in manifest header \"" + HEADER_BUNDLE_SYMBOLIC_NAME + "\"; skipping " + file, new Object[0]);
                    }
                    return true;
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not read contents of " + file, ioe);
        }
        return false;
    }
}

