/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.BufferManager;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.giop.CodeSet;
import org.jacorb.orb.giop.ConnectionListener;
import org.jacorb.orb.giop.MessageOutputStream;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ReplyListener;
import org.jacorb.orb.giop.ReplyOutputStream;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.orb.giop.StatisticsProvider;
import org.jacorb.orb.giop.StatisticsProviderAdapter;
import org.jacorb.orb.iiop.IIOPConnection;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSIENT;
import org.omg.ETF.BufferHolder;
import org.omg.ETF.Connection;
import org.omg.ETF.Profile;
import org.omg.GIOP.ReplyStatusType_1_2;
import org.slf4j.Logger;

public abstract class GIOPConnection
extends OutputStream {
    protected final Profile profile;
    protected Connection transport = null;
    private RequestListener request_listener = null;
    private ReplyListener reply_listener = null;
    protected ConnectionListener connection_listener = null;
    protected Object connect_sync = new Object();
    private boolean writer_active = false;
    private final Object write_sync = new Object();
    protected Logger logger;
    private CodeSet tcs = CodeSet.getTCSDefault();
    private CodeSet tcsw = CodeSet.getTCSWDefault();
    private boolean tcs_negotiated = false;
    private final Map fragments = new HashMap();
    private final BufferManager buf_mg;
    private boolean dump_incoming = false;
    private long timeout = 0L;
    private final BufferHolder msg_header = new BufferHolder(new byte[12]);
    private final BufferHolder inbuf = new BufferHolder();
    private static int cubby_count = 0;
    private Object[] cubbyholes = null;
    private int pending_messages = 0;
    private int pending_write = 0;
    protected boolean discard_messages = false;
    protected Object pendingUndecidedSync = new Object();
    protected boolean do_close = false;
    protected StatisticsProvider statistics_provider = null;
    protected StatisticsProviderAdapter statistics_provider_adapter = null;

    public GIOPConnection(Profile profile, Connection connection, RequestListener requestListener, ReplyListener replyListener, StatisticsProvider statisticsProvider) {
        this.profile = profile;
        this.transport = connection;
        this.request_listener = requestListener;
        this.reply_listener = replyListener;
        this.statistics_provider = statisticsProvider;
        if (statisticsProvider != null) {
            this.statistics_provider_adapter = new StatisticsProviderAdapter(statisticsProvider);
        }
        this.buf_mg = BufferManager.getInstance();
        this.cubbyholes = new Object[cubby_count];
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration configuration2 = configuration;
        this.logger = configuration2.getLogger("jacorb.giop.conn");
        this.dump_incoming = configuration.getAttribute("jacorb.debug.dump_incoming_messages", "off").equals("on");
        this.timeout = configuration.getAttributeAsInteger("jacorb.connection.client.connect_timeout", 90000);
        List list = configuration2.getAttributeList("jacorb.connection.statistics_providers");
        for (String string : list) {
            try {
                Class clazz = ObjectUtil.classForName(string);
                this.statistics_provider_adapter = new StatisticsProviderAdapter((StatisticsProvider)clazz.newInstance(), this.statistics_provider_adapter);
            }
            catch (Exception exception) {
                if (!this.logger.isErrorEnabled()) continue;
                this.logger.error("Unable to create class from property >jacorb.connection.statistics_provider_class<: " + exception.toString());
            }
        }
    }

    public final void setCodeSets(CodeSet codeSet, CodeSet codeSet2) {
        this.tcs = codeSet;
        this.tcsw = codeSet2;
    }

    public final void setCodeSets(int n, int n2) {
        this.tcs = CodeSet.getCodeSet(n);
        this.tcsw = CodeSet.getCodeSet(n2);
    }

    public final CodeSet getTCS() {
        return this.tcs;
    }

    public final CodeSet getTCSW() {
        return this.tcsw;
    }

    public final void markTCSNegotiated() {
        this.tcs_negotiated = true;
    }

    public final boolean isTCSNegotiated() {
        return this.tcs_negotiated;
    }

    protected final synchronized RequestListener getRequestListener() {
        return this.request_listener;
    }

    public final synchronized void setRequestListener(RequestListener requestListener) {
        this.request_listener = requestListener;
    }

    private final synchronized ReplyListener getReplyListener() {
        return this.reply_listener;
    }

    public final synchronized void setReplyListener(ReplyListener replyListener) {
        this.reply_listener = replyListener;
    }

    public final void setConnectionListener(ConnectionListener connectionListener) {
        this.connection_listener = connectionListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Connection getTransport() {
        Object object = this.connect_sync;
        synchronized (object) {
            return this.transport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitUntilConnected() {
        Object object = this.connect_sync;
        synchronized (object) {
            while (!this.transport.is_connected() && !this.do_close) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(this.toString() + ": will wait until connected");
                }
                try {
                    this.connect_sync.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return !this.do_close;
        }
    }

    protected abstract void readTimedOut();

    protected abstract void streamClosed();

    private byte[] getMessage() {
        if (!this.waitUntilConnected()) {
            return null;
        }
        try {
            this.transport.read(this.msg_header, 0, 12, 12, 0L);
        }
        catch (TRANSIENT tRANSIENT) {
            return null;
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.toString() + ": getMessage() -- COMM_FAILURE");
            }
            this.streamClosed();
            return null;
        }
        catch (TIMEOUT tIMEOUT) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.toString() + ": getMessage() -- TIMEOUT");
            }
            this.readTimedOut();
            return null;
        }
        byte[] byArray = this.msg_header.value;
        if (Messages.matchGIOPMagic(byArray)) {
            int n = Messages.getMsgSize(byArray);
            if (n < 0) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Negative GIOP message size (" + n + ") in " + this.toString());
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("GIOPConnection.getMessage() with header: \n" + new String(byArray) + "\nsize : " + 12 + ", in " + this.toString());
                }
                return null;
            }
            this.inbuf.value = this.buf_mg.getBuffer(n + 12);
            System.arraycopy(byArray, 0, this.inbuf.value, 0, 12);
            try {
                this.transport.read(this.inbuf, 12, n, n, 0L);
            }
            catch (COMM_FAILURE cOMM_FAILURE) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Failed to read GIOP message in " + this.toString(), (Throwable)cOMM_FAILURE);
                }
                return null;
            }
            if (this.dump_incoming && this.logger.isInfoEnabled()) {
                this.logger.info(this.toString() + " BufferDump:\n" + ObjectUtil.bufToString(this.inbuf.value, 0, n + 12));
            }
            if (this.getStatisticsProviderAdapter() != null) {
                this.getStatisticsProviderAdapter().messageReceived(n + 12);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("read GIOP message of size {} from {}", (Object)(n + 12), (Object)this.toString());
            }
            return this.inbuf.value;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.toString() + " getMessage(), invalid header read: " + ObjectUtil.bufToString(this.msg_header.value, 0, 4));
        }
        if (this.logger.isErrorEnabled()) {
            this.logger.error("Failed to read GIOP message in " + this.toString() + ", incorrect magic number --> connection closed");
        }
        this.streamClosed();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void receiveMessages() throws IOException {
        while (true) {
            byte[] byArray;
            if ((byArray = this.getMessage()) == null) {
                if (!this.do_close) continue;
                return;
            }
            Object object = this.pendingUndecidedSync;
            synchronized (object) {
                OutputStream outputStream;
                if (this.discard_messages) {
                    this.buf_mg.returnBuffer(byArray);
                    continue;
                }
                if (Messages.getGIOPMajor(byArray) != 1) {
                    if (this.logger.isErrorEnabled()) {
                        this.logger.error("Invalid GIOP major version encountered: " + Messages.getGIOPMajor(byArray) + ", in " + this.toString());
                    }
                    this.buf_mg.returnBuffer(byArray);
                    continue;
                }
                int n = Messages.getMsgType(byArray);
                if (n == 7) {
                    if (Messages.getGIOPMinor(byArray) == 0) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("Received a GIOP 1.0 message of type Fragment in " + this.toString());
                        }
                        MessageOutputStream messageOutputStream = new MessageOutputStream();
                        try {
                            messageOutputStream.writeGIOPMsgHeader(6, 0);
                            messageOutputStream.insertMsgSize();
                            this.sendMessage(messageOutputStream);
                            this.buf_mg.returnBuffer(byArray);
                        }
                        finally {
                            messageOutputStream.close();
                        }
                        continue;
                    }
                    if (Messages.getGIOPMinor(byArray) == 1) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("Received a GIOP 1.1 Fragment message in " + this.toString());
                        }
                        this.buf_mg.returnBuffer(byArray);
                        continue;
                    }
                    Integer n2 = ObjectUtil.newInteger(Messages.getRequestId(byArray));
                    if (!this.fragments.containsKey(n2)) {
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error("No previous Fragment to this one in " + this.toString());
                        }
                        this.buf_mg.returnBuffer(byArray);
                        continue;
                    }
                    outputStream = (ByteArrayOutputStream)this.fragments.get(n2);
                    ((ByteArrayOutputStream)outputStream).write(byArray, 16, Messages.getMsgSize(byArray) - 4);
                    if (Messages.moreFragmentsFollow(byArray)) {
                        this.buf_mg.returnBuffer(byArray);
                        continue;
                    }
                    this.buf_mg.returnBuffer(byArray);
                    byArray = ((ByteArrayOutputStream)outputStream).toByteArray();
                    n = Messages.getMsgType(byArray);
                    this.fragments.remove(n2);
                } else if (Messages.moreFragmentsFollow(byArray)) {
                    if (Messages.getGIOPMinor(byArray) == 0) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("Received a GIOP 1.0 message with the \"more fragments follow\"bits set in " + this.toString());
                        }
                        MessageOutputStream messageOutputStream = new MessageOutputStream();
                        messageOutputStream.writeGIOPMsgHeader(6, 0);
                        messageOutputStream.insertMsgSize();
                        this.sendMessage(messageOutputStream);
                        this.buf_mg.returnBuffer(byArray);
                        continue;
                    }
                    if (Messages.getGIOPMinor(byArray) == 1) {
                        if (n != 0 && n != 1) {
                            if (this.logger.isWarnEnabled()) {
                                this.logger.warn("Received a GIOP 1.1 message of type " + n + " with the " + "" + "\"more fragments follow\" bits set" + " in " + this.toString());
                            }
                            MessageOutputStream messageOutputStream = new MessageOutputStream();
                            messageOutputStream.writeGIOPMsgHeader(6, 1);
                            messageOutputStream.insertMsgSize();
                            this.sendMessage(messageOutputStream);
                            this.buf_mg.returnBuffer(byArray);
                            continue;
                        }
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("Received a fragmented GIOP 1.1 message in " + this.toString());
                        }
                        int n3 = Messages.getGIOPMinor(byArray);
                        outputStream = new ReplyOutputStream(Messages.getRequestId(byArray), ReplyStatusType_1_2.SYSTEM_EXCEPTION, n3, false, this.logger);
                        SystemExceptionHelper.write((org.omg.CORBA.portable.OutputStream)outputStream, new NO_IMPLEMENT(0, CompletionStatus.COMPLETED_NO));
                        this.sendMessage((MessageOutputStream)outputStream);
                        this.buf_mg.returnBuffer(byArray);
                        continue;
                    }
                    if (n == 2 || n == 5 || n == 2) {
                        if (this.logger.isWarnEnabled()) {
                            this.logger.warn("Received a GIOP message of type " + n + " with the \"more fragments follow\" bits set, " + "but this message type isn't allowed to be " + "fragmented, in " + this.toString());
                        }
                        MessageOutputStream messageOutputStream = new MessageOutputStream();
                        messageOutputStream.writeGIOPMsgHeader(6, 1);
                        messageOutputStream.insertMsgSize();
                        this.sendMessage(messageOutputStream);
                        this.buf_mg.returnBuffer(byArray);
                        continue;
                    }
                    Integer n4 = new Integer(Messages.getRequestId(byArray));
                    if (this.fragments.containsKey(n4)) {
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error("Received a message of type " + n + " with the more fragments follow bit set," + " but there is already an fragmented," + " incomplete message with the same request id (" + n4 + ", in " + this.toString());
                        }
                        this.buf_mg.returnBuffer(byArray);
                        continue;
                    }
                    outputStream = new ByteArrayOutputStream();
                    this.fragments.put(n4, outputStream);
                    ((ByteArrayOutputStream)outputStream).write(byArray, 0, 12 + Messages.getMsgSize(byArray));
                    this.buf_mg.returnBuffer(byArray);
                    continue;
                }
                switch (n) {
                    case 0: {
                        this.getRequestListener().requestReceived(byArray, this);
                        break;
                    }
                    case 1: {
                        this.getReplyListener().replyReceived(byArray, this);
                        break;
                    }
                    case 2: {
                        this.getRequestListener().cancelRequestReceived(byArray, this);
                        break;
                    }
                    case 3: {
                        this.getRequestListener().locateRequestReceived(byArray, this);
                        break;
                    }
                    case 4: {
                        this.getReplyListener().locateReplyReceived(byArray, this);
                        break;
                    }
                    case 5: {
                        this.getReplyListener().closeConnectionReceived(byArray, this);
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 7: {
                        break;
                    }
                    default: {
                        if (this.logger.isErrorEnabled()) {
                            this.logger.error("Received message with unknown message type " + n + ", in " + this.toString());
                        }
                        this.buf_mg.returnBuffer(byArray);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void getWriteLock() {
        Object object = this.write_sync;
        synchronized (object) {
            while (this.writer_active) {
                try {
                    this.write_sync.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.writer_active = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void releaseWriteLock() {
        Object object = this.write_sync;
        synchronized (object) {
            this.writer_active = false;
            this.write_sync.notifyAll();
        }
    }

    private final synchronized void incPendingWrite() {
        ++this.pending_write;
    }

    private final synchronized void decPendingWrite() {
        --this.pending_write;
    }

    public final synchronized void incPendingMessages() {
        ++this.pending_messages;
    }

    public final synchronized void decPendingMessages() {
        --this.pending_messages;
    }

    public final synchronized boolean hasPendingMessages() {
        return this.pending_messages != 0 || this.pending_write != 0;
    }

    public final void write(byte[] byArray, int n, int n2) {
        this.transport.write(false, false, byArray, n, n2, 0L);
        if (this.getStatisticsProviderAdapter() != null) {
            this.getStatisticsProviderAdapter().messageChunkSent(n2);
        }
    }

    public final void write(int n) throws IOException {
        throw new NO_IMPLEMENT();
    }

    public final void write(byte[] byArray) throws IOException {
        throw new NO_IMPLEMENT();
    }

    public final void flush() throws IOException {
        throw new NO_IMPLEMENT();
    }

    public final void sendRequest(MessageOutputStream messageOutputStream, boolean bl) throws IOException {
        if (bl) {
            this.incPendingMessages();
        }
        this.sendMessage(messageOutputStream);
    }

    public final void sendReply(MessageOutputStream messageOutputStream) throws IOException {
        this.decPendingMessages();
        this.sendMessage(messageOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendMessage(MessageOutputStream messageOutputStream) throws IOException {
        try {
            try {
                this.incPendingWrite();
                this.getWriteLock();
                if (!this.transport.is_connected()) {
                    this.tcs_negotiated = false;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(this.toString() + ": sendMessage() -- opening transport");
                    }
                    Object object = this.connect_sync;
                    synchronized (object) {
                        try {
                            this.transport.connect(this.profile, this.timeout);
                            this.connect_sync.notifyAll();
                        }
                        catch (RuntimeException runtimeException) {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug(this.toString() + ": sendMessage() -- failed to open transport");
                            }
                            throw runtimeException;
                        }
                    }
                }
                messageOutputStream.write_to(this);
                this.transport.flush();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("wrote GIOP message of size {} to {}", (Object)messageOutputStream.size(), (Object)this.toString());
                }
                if (this.getStatisticsProviderAdapter() != null) {
                    this.getStatisticsProviderAdapter().flushed();
                }
            }
            finally {
                this.decPendingWrite();
                this.releaseWriteLock();
            }
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Failed to write GIOP message due to COMM_FAILURE, in " + this.toString(), (Throwable)cOMM_FAILURE);
            }
            if (!this.do_close) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Underlying transport connection closed due to errors during sendMessage(), in " + this.toString());
                }
                this.streamClosed();
            }
            throw cOMM_FAILURE;
        }
    }

    public final boolean isSSL() {
        return this.transport instanceof IIOPConnection && ((IIOPConnection)this.transport).isSSL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.toString() + ": close()");
        }
        Object object = this.connect_sync;
        synchronized (object) {
            if (this.connection_listener != null) {
                this.connection_listener.connectionClosed();
            }
            this.transport.close();
            this.do_close = true;
            this.connect_sync.notifyAll();
        }
    }

    protected final StatisticsProviderAdapter getStatisticsProviderAdapter() {
        return this.statistics_provider_adapter;
    }

    public final StatisticsProvider getStatisticsProvider() {
        return this.statistics_provider;
    }

    public StatisticsProvider getStatisticsProvider(int n) {
        if (this.statistics_provider_adapter == null) {
            return null;
        }
        return this.statistics_provider_adapter.find(n);
    }

    public static int allocate_cubby_id() {
        return cubby_count++;
    }

    public Object get_cubby(int n) {
        if (n < 0 || n >= cubby_count) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Get bad cubby id " + n + " (max=" + cubby_count + "), in " + this.toString());
            }
            return null;
        }
        return this.cubbyholes[n];
    }

    public void set_cubby(int n, Object object) {
        if (n < 0 || n >= cubby_count) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Set bad cubby id " + n + " (max=" + cubby_count + "), in " + this.toString());
            }
            return;
        }
        this.cubbyholes[n] = object;
    }

    Profile getProfile() {
        return this.profile;
    }
}

