/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.imr.ImRAccessImpl;
import org.jacorb.ir.RepositoryID;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.ClientInterceptorHandler;
import org.jacorb.orb.LocateReplyReceiver;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.Reference;
import org.jacorb.orb.ReplyReceiver;
import org.jacorb.orb.SpecificProfileSelector;
import org.jacorb.orb.SystemExceptionHelper;
import org.jacorb.orb.dii.Request;
import org.jacorb.orb.giop.ClientConnection;
import org.jacorb.orb.giop.ClientConnectionManager;
import org.jacorb.orb.giop.LocateReplyInputStream;
import org.jacorb.orb.giop.LocateRequestOutputStream;
import org.jacorb.orb.giop.ReplyInputStream;
import org.jacorb.orb.giop.ReplyPlaceholder;
import org.jacorb.orb.giop.RequestOutputStream;
import org.jacorb.orb.portableInterceptor.ClientInterceptorIterator;
import org.jacorb.orb.portableInterceptor.ClientRequestInfoImpl;
import org.jacorb.orb.util.CorbaLoc;
import org.jacorb.poa.LocalInvocationContext;
import org.jacorb.poa.POA;
import org.jacorb.poa.util.POAUtil;
import org.jacorb.util.ObjectUtil;
import org.jacorb.util.Time;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyHelper;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.CORBA.portable.ServantObject;
import org.omg.ETF.Profile;
import org.omg.IOP.IOR;
import org.omg.Messaging.RelativeRequestTimeoutPolicy;
import org.omg.Messaging.RelativeRoundtripTimeoutPolicy;
import org.omg.Messaging.ReplyEndTimePolicy;
import org.omg.Messaging.ReplyHandler;
import org.omg.Messaging.ReplyStartTimePolicy;
import org.omg.Messaging.RequestEndTimePolicy;
import org.omg.Messaging.RequestStartTimePolicy;
import org.omg.Messaging.SyncScopePolicy;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.WrongAdapter;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantActivator;
import org.omg.PortableServer.ServantLocator;
import org.omg.PortableServer.ServantLocatorPackage.CookieHolder;
import org.omg.PortableServer.ServantManager;
import org.omg.RTCORBA.ClientProtocolPolicy;
import org.omg.RTCORBA.Protocol;
import org.omg.TimeBase.UtcT;
import org.slf4j.Logger;

public final class Delegate
extends org.omg.CORBA_2_3.portable.Delegate
implements Configurable {
    private ParsedIOR _pior = null;
    private IOR ior = null;
    private ClientConnection connection = null;
    private String objectReference = null;
    private ParsedIOR piorOriginal = null;
    private ParsedIOR piorLastFailed = null;
    private boolean isImR = false;
    private boolean bound = false;
    private POA poa;
    private final ORB orb;
    private Logger logger = null;
    private boolean resolved_locality = false;
    private final Set pending_replies = new HashSet();
    private final Barrier pending_replies_sync = new Barrier();
    private final java.lang.Object bind_sync = new java.lang.Object();
    private boolean locate_on_bind_performed = false;
    private ClientConnectionManager conn_mg = null;
    private Map policy_overrides;
    private boolean doNotCheckExceptions = false;
    private CookieHolder cookie = null;
    private String invokedOperation = null;
    private static final ThreadLocal localInterceptors = new ThreadLocal();
    private Configuration configuration = null;
    private boolean useIMR;
    private boolean locateOnBind;
    private static final ThreadLocal ignoreNextCallToIsLocal = new ThreadLocal(){

        protected java.lang.Object initialValue() {
            return Boolean.FALSE;
        }
    };

    private Delegate(ORB oRB) {
        this.orb = oRB;
    }

    public Delegate(ORB oRB, ParsedIOR parsedIOR) {
        this(oRB);
        this._pior = parsedIOR;
        this.checkIfImR(this._pior.getTypeId());
        this.conn_mg = oRB.getClientConnectionManager();
    }

    public Delegate(ORB oRB, String string) {
        this(oRB);
        if (string.indexOf("IOR:") != 0) {
            throw new INV_OBJREF("Not an IOR: " + string);
        }
        this.objectReference = string;
        this.conn_mg = oRB.getClientConnectionManager();
    }

    public Delegate(ORB oRB, IOR iOR) {
        this(oRB);
        this.ior = iOR;
        this.conn_mg = oRB.getClientConnectionManager();
    }

    public Delegate(ORB oRB, String string, boolean bl) {
        this(oRB, string);
        this.doNotCheckExceptions = bl;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = configuration;
        this.logger = configuration.getLogger("jacorb.orb.delegate");
        this.useIMR = configuration.getAttribute("jacorb.use_imr", "off").equals("on");
        this.locateOnBind = configuration.getAttribute("jacorb.locate_on_bind", "off").equals("on");
        if (this.objectReference != null) {
            this._pior = new ParsedIOR(this.orb, this.objectReference);
        } else if (this.ior != null) {
            this._pior = new ParsedIOR(this.orb, this.ior);
        } else if (this._pior == null) {
            throw new ConfigurationException("Neither objectReference nor IOR set!");
        }
        this.checkIfImR(this._pior.getTypeId());
    }

    public boolean doNotCheckExceptions() {
        return this.doNotCheckExceptions;
    }

    private void checkIfImR(String string) {
        if ("IDL:org/jacorb/imr/ImplementationRepository:1.0".equals(string)) {
            this.isImR = true;
        }
    }

    public int _get_TCKind() {
        return 14;
    }

    private void bind() {
        this.bind(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bind(boolean bl) {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            block17: {
                Protocol[] protocolArray;
                if (this.bound) {
                    return;
                }
                if (!bl && (protocolArray = this.getClientProtocols()) != null) {
                    this._pior.setProfileSelector(new SpecificProfileSelector(protocolArray));
                }
                if ((protocolArray = this._pior.getEffectiveProfile()) == null) {
                    throw new COMM_FAILURE("no effective profile");
                }
                this.connection = this.conn_mg.getConnection((Profile)protocolArray);
                this.bound = true;
                if (!this.locate_on_bind_performed && this.locateOnBind) {
                    this.locate_on_bind_performed = true;
                    try {
                        LocateRequestOutputStream locateRequestOutputStream = new LocateRequestOutputStream(this._pior.get_object_key(), this.connection.getId(), this._pior.getEffectiveProfile().version().minor);
                        LocateReplyReceiver locateReplyReceiver = new LocateReplyReceiver(this.orb);
                        this.connection.sendRequest(locateRequestOutputStream, locateReplyReceiver, locateRequestOutputStream.getRequestId(), true);
                        LocateReplyInputStream locateReplyInputStream = locateReplyReceiver.getReply();
                        switch (locateReplyInputStream.rep_hdr.locate_status.value()) {
                            case 0: {
                                throw new UNKNOWN("Could not bind to object, server does not know it!");
                            }
                            case 1: {
                                break;
                            }
                            case 2: 
                            case 3: {
                                this.rebind(locateReplyInputStream.read_Object());
                                break;
                            }
                            case 4: {
                                throw SystemExceptionHelper.read(locateReplyInputStream);
                            }
                            case 5: {
                                throw new NO_IMPLEMENT("Server responded to LocateRequest with a status of LOC_NEEDS_ADDRESSING_MODE, but this isn't yet implemented by JacORB");
                            }
                            default: {
                                throw new IllegalArgumentException("Unknown reply status for LOCATE_REQUEST: " + locateReplyInputStream.rep_hdr.locate_status.value());
                            }
                        }
                    }
                    catch (SystemException systemException) {
                        throw systemException;
                    }
                    catch (Exception exception) {
                        if (!this.logger.isWarnEnabled()) break block17;
                        this.logger.warn(exception.getMessage());
                    }
                }
            }
            this.bind_sync.notifyAll();
        }
    }

    public void rebind(Object object) {
        String string = this.orb.object_to_string(object);
        if (string.indexOf("IOR:") != 0) {
            throw new INV_OBJREF("Not an IOR: " + string);
        }
        this.rebind(new ParsedIOR(this.orb, string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebind(ParsedIOR parsedIOR) {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            ParsedIOR parsedIOR2 = this.getParsedIOR();
            boolean bl = parsedIOR2.equals(parsedIOR);
            Protocol[] protocolArray = this.getClientProtocols();
            if (protocolArray != null) {
                parsedIOR.setProfileSelector(new SpecificProfileSelector(protocolArray));
            }
            if (bl && parsedIOR.equals(parsedIOR2)) {
                return;
            }
            if (this.piorLastFailed != null && this.piorLastFailed.equals(parsedIOR)) {
                throw new TRANSIENT();
            }
            if (this.piorOriginal == null) {
                this.piorOriginal = this._pior;
            }
            this._pior = parsedIOR;
            if (this.connection != null) {
                this.conn_mg.releaseConnection(this.connection);
                this.connection = null;
            }
            this.bound = false;
            this.bind();
        }
    }

    public org.omg.CORBA.Request create_request(Object object, Context context, String string, NVList nVList, NamedValue namedValue) {
        this.checkORB();
        this.bind();
        return new Request(object, this.orb, this.connection, this.getParsedIOR().get_object_key(), string, nVList, context, namedValue);
    }

    public org.omg.CORBA.Request create_request(Object object, Context context, String string, NVList nVList, NamedValue namedValue, ExceptionList exceptionList, ContextList contextList) {
        throw new NO_IMPLEMENT();
    }

    public synchronized Object duplicate(Object object) {
        return object;
    }

    public boolean equals(java.lang.Object object) {
        return object instanceof Object && this.toString().equals(object.toString());
    }

    public boolean equals(Object object, java.lang.Object object2) {
        return this.equals(object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.release(null);
        }
        finally {
            super.finalize();
        }
    }

    public DomainManager[] get_domain_managers(Object object) {
        return null;
    }

    public Policy get_policy(Object object, int n) {
        Policy policy = this.get_client_policy(n);
        if (policy != null) {
            return policy;
        }
        return this.get_policy(object, n, this.request(object, "_get_policy", true));
    }

    public Policy get_client_policy(int n) {
        Policy[] policyArray;
        Serializable serializable;
        Policy policy = null;
        if (this.policy_overrides != null) {
            serializable = ObjectUtil.newInteger(n);
            policy = (Policy)this.policy_overrides.get(serializable);
        }
        if (policy == null && (serializable = this.orb.getPolicyManager()) != null && (policyArray = serializable.get_policy_overrides(new int[]{n})) != null && policyArray.length == 1) {
            policy = policyArray[0];
        }
        return policy;
    }

    public Policy get_policy(Object object, int n, OutputStream outputStream) {
        while (true) {
            try {
                outputStream.write_Object(object);
                outputStream.write_long(n);
                InputStream inputStream = this.invoke(object, outputStream);
                return PolicyHelper.narrow(inputStream.read_Object());
            }
            catch (RemarshalException remarshalException) {
                continue;
            }
            catch (ApplicationException applicationException) {
                String string = applicationException.getId();
                throw new INTERNAL("Unexpected exception " + string);
            }
            break;
        }
    }

    public UtcT getRequestEndTime() {
        Policy policy = this.get_client_policy(28);
        if (policy != null) {
            return ((RequestEndTimePolicy)policy).end_time();
        }
        return null;
    }

    public UtcT getReplyEndTime() {
        Policy policy = this.get_client_policy(30);
        if (policy != null) {
            return ((ReplyEndTimePolicy)policy).end_time();
        }
        return null;
    }

    public UtcT getRequestStartTime() {
        Policy policy = this.get_client_policy(27);
        if (policy != null) {
            return ((RequestStartTimePolicy)policy).start_time();
        }
        return null;
    }

    public UtcT getReplyStartTime() {
        Policy policy = this.get_client_policy(29);
        if (policy != null) {
            return ((ReplyStartTimePolicy)policy).start_time();
        }
        return null;
    }

    public long getRelativeRoundtripTimeout() {
        Policy policy = this.get_client_policy(32);
        if (policy != null) {
            return ((RelativeRoundtripTimeoutPolicy)policy).relative_expiry();
        }
        return -1L;
    }

    public long getRelativeRequestTimeout() {
        Policy policy = this.get_client_policy(31);
        if (policy != null) {
            return ((RelativeRequestTimeoutPolicy)policy).relative_expiry();
        }
        return -1L;
    }

    public short getSyncScope() {
        Policy policy = this.get_client_policy(24);
        if (policy != null) {
            return ((SyncScopePolicy)policy).synchronization();
        }
        return 1;
    }

    public Protocol[] getClientProtocols() {
        Policy policy = this.get_client_policy(43);
        if (policy != null) {
            return ((ClientProtocolPolicy)policy).protocols();
        }
        return null;
    }

    public InterfaceDef get_interface(Object object) {
        return InterfaceDefHelper.narrow(this.get_interface_def(object));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object get_interface_def(Object object) {
        this.checkORB();
        if (this.is_really_local(object)) {
            ServantObject servantObject = this.servant_preinvoke(object, "_interface", java.lang.Object.class);
            if (servantObject == null) {
                throw new OBJ_ADAPTER("Servant from pre_invoke was null");
            }
            try {
                Servant servant = (Servant)servantObject.servant;
                this.orb.set_delegate(servant);
                Object object2 = servant._get_interface_def();
                return object2;
            }
            finally {
                this.servant_postinvoke(object, servantObject);
            }
        }
        while (true) {
            try {
                OutputStream outputStream = this.request(object, "_interface", true);
                InputStream inputStream = this.invoke(object, outputStream);
                return inputStream.read_Object();
            }
            catch (RemarshalException remarshalException) {
                continue;
            }
            break;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientConnection getConnection() {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            this.bind();
            return this.connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOR getIOR() {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            if (this.piorOriginal != null) {
                return this.piorOriginal.getIOR();
            }
            return this.getParsedIOR().getIOR();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getObjectId() {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            this.bind();
            return POAUtil.extractOID(this.getParsedIOR().get_object_key());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getObjectKey() {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            this.bind();
            return this.getParsedIOR().get_object_key();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParsedIOR getParsedIOR() {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            while (this._pior == null) {
                try {
                    this.bind_sync.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return this._pior;
        }
    }

    public void resolvePOA(Object object) {
        if (!this.resolved_locality) {
            this.resolved_locality = true;
            POA pOA = this.orb.findPOA(this, object);
            if (pOA != null) {
                this.poa = pOA;
            }
        }
    }

    public POA getPOA() {
        return this.poa;
    }

    public ObjectImpl getReference(POA pOA) {
        if (pOA != null) {
            this.poa = pOA;
        }
        Reference reference = new Reference(this.typeId());
        ((ObjectImpl)((java.lang.Object)reference))._set_delegate(this);
        return reference;
    }

    public int hash(Object object, int n) {
        this.checkORB();
        return this.hashCode();
    }

    public int hashCode() {
        return this.getIDString().hashCode();
    }

    public int hashCode(Object object) {
        return this.hashCode();
    }

    public void invoke(Object object, OutputStream outputStream, ReplyHandler replyHandler) throws ApplicationException, RemarshalException {
        this.invoke_internal(object, outputStream, replyHandler, true);
    }

    public InputStream invoke(Object object, OutputStream outputStream) throws ApplicationException, RemarshalException {
        return this.invoke_internal(object, outputStream, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream invoke_internal(Object object, OutputStream outputStream, ReplyHandler replyHandler, boolean bl) throws ApplicationException, RemarshalException {
        java.lang.Object object2;
        this.checkORB();
        RequestOutputStream requestOutputStream = (RequestOutputStream)outputStream;
        ReplyReceiver replyReceiver = null;
        ClientInterceptorHandler clientInterceptorHandler = new ClientInterceptorHandler((ClientInterceptorHandler)localInterceptors.get(), this.orb, requestOutputStream, object, this, this.piorOriginal, this.connection);
        this.orb.notifyTransportListeners(this.connection.getGIOPConnection());
        if (this.orb.hasRequestInterceptors()) {
            localInterceptors.set(clientInterceptorHandler);
            try {
                clientInterceptorHandler.handle_send_request();
            }
            catch (RuntimeException runtimeException) {
                localInterceptors.set(null);
                throw runtimeException;
            }
        } else {
            clientInterceptorHandler.handle_send_request();
        }
        try {
            if (!requestOutputStream.response_expected()) {
                this.invoke_oneway(requestOutputStream, clientInterceptorHandler);
                InputStream inputStream = null;
                return inputStream;
            }
            replyReceiver = new ReplyReceiver(this, requestOutputStream.operation(), requestOutputStream.getReplyEndTime(), clientInterceptorHandler, replyHandler);
            replyReceiver.configure(this.configuration);
            object2 = this.pending_replies;
            synchronized (object2) {
                this.pending_replies.add(replyReceiver);
            }
            object2 = null;
            java.lang.Object object3 = this.bind_sync;
            synchronized (object3) {
                if (requestOutputStream.getConnection() != this.connection) {
                    this.logger.debug("invoke: RemarshalException");
                    throw new RemarshalException();
                }
                object2 = this.connection;
            }
            ((ClientConnection)object2).sendRequest(requestOutputStream, replyReceiver, requestOutputStream.requestId(), true);
        }
        catch (SystemException systemException) {
            this.logger.debug("invoke: SystemException");
            if (!bl) {
                Set set = this.pending_replies;
                synchronized (set) {
                    this.pending_replies.remove(replyReceiver);
                }
            }
            clientInterceptorHandler.handle_receive_exception(systemException);
            if (systemException instanceof TRANSIENT && this.try_rebind()) {
                throw new RemarshalException();
            }
            throw systemException;
        }
        finally {
            if (this.orb.hasRequestInterceptors()) {
                localInterceptors.set(null);
            }
        }
        if (!bl && replyReceiver != null) {
            object2 = replyReceiver.getReply();
            ((CDRInputStream)object2).updateMutatorConnection(this.connection.getGIOPConnection());
            return object2;
        }
        return null;
    }

    private void invoke_oneway(RequestOutputStream requestOutputStream, ClientInterceptorHandler clientInterceptorHandler) throws RemarshalException, ApplicationException {
        switch (requestOutputStream.syncScope()) {
            case 0: {
                RequestOutputStream requestOutputStream2 = new RequestOutputStream(requestOutputStream);
                this.passToTransport(requestOutputStream2);
                clientInterceptorHandler.handle_receive_other((short)0);
                break;
            }
            case 1: {
                this.connection.sendRequest(requestOutputStream, false);
                clientInterceptorHandler.handle_receive_other((short)0);
                break;
            }
            case 2: 
            case 3: {
                ReplyReceiver replyReceiver = new ReplyReceiver(this, requestOutputStream.operation(), requestOutputStream.getReplyEndTime(), clientInterceptorHandler, null);
                replyReceiver.configure(this.configuration);
                this.connection.sendRequest(requestOutputStream, replyReceiver, requestOutputStream.requestId(), true);
                ReplyInputStream replyInputStream = replyReceiver.getReply();
                clientInterceptorHandler.handle_receive_reply(replyInputStream);
                break;
            }
            default: {
                throw new MARSHAL("Illegal SYNC_SCOPE: " + requestOutputStream.syncScope(), 0, CompletionStatus.COMPLETED_MAYBE);
            }
        }
    }

    private void passToTransport(final RequestOutputStream requestOutputStream) {
        new Thread(new Runnable(){

            public void run() {
                Delegate.this.connection.sendRequest(requestOutputStream, false);
            }
        }, "PassToTransport").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean try_rebind() {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Delegate.try_rebind");
            }
            if (this.piorOriginal != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Delegate: falling back to original IOR");
                }
                this.piorLastFailed = this.getParsedIOR();
                this.rebind(this.piorOriginal);
                this.piorOriginal = null;
                this.piorLastFailed = null;
                return true;
            }
            if (this.useIMR && !this.isImR) {
                Integer n = this.getParsedIOR().getORBTypeId();
                if (n == null || n != 1245790976) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Delegate: foreign IOR detected");
                    }
                    return false;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Delegate: JacORB IOR detected");
                }
                byte[] byArray = this.getParsedIOR().get_object_key();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Delegate: attempting to contact ImR");
                }
                ImRAccessImpl imRAccessImpl = null;
                try {
                    imRAccessImpl = ImRAccessImpl.connect(this.orb);
                }
                catch (Exception exception) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Delegate: failed to contact ImR");
                    }
                    return false;
                }
                StringBuffer stringBuffer = new StringBuffer("corbaloc:iiop:");
                stringBuffer.append(imRAccessImpl.getImRHost());
                stringBuffer.append(':');
                stringBuffer.append(imRAccessImpl.getImRPort());
                stringBuffer.append('/');
                stringBuffer.append(CorbaLoc.parseKey(byArray));
                this.rebind(new ParsedIOR(this.orb, stringBuffer.toString()));
                this.piorOriginal = null;
                this.piorLastFailed = null;
                return true;
            }
            return false;
        }
    }

    public void invokeInterceptors(ClientRequestInfoImpl clientRequestInfoImpl, short s) throws RemarshalException {
        block3: {
            ClientInterceptorIterator clientInterceptorIterator = this.orb.getInterceptorManager().getClientIterator();
            try {
                clientInterceptorIterator.iterate(clientRequestInfoImpl, s);
            }
            catch (ForwardRequest forwardRequest) {
                this.rebind(forwardRequest.forward);
                throw new RemarshalException();
            }
            catch (UserException userException) {
                if (!this.logger.isErrorEnabled()) break block3;
                this.logger.error(userException.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean is_a(Object object, String string) {
        ParsedIOR parsedIOR = this.getParsedIOR();
        if (parsedIOR.getTypeId().equals(string)) {
            return true;
        }
        String[] stringArray = ((ObjectImpl)object)._ids();
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        if (this.is_really_local(object)) {
            ServantObject servantObject;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Located " + object + " on local POA; assuming local.");
            }
            if ((servantObject = this.servant_preinvoke(object, "_is_a", java.lang.Object.class)) == null) {
                throw new OBJ_ADAPTER("Servant from pre_invoke was null");
            }
            try {
                Servant servant = (Servant)servantObject.servant;
                this.orb.set_delegate(servant);
                boolean bl = servant._is_a(string);
                return bl;
            }
            finally {
                this.servant_postinvoke(object, servantObject);
            }
        }
        if (!stringArray[0].equals("IDL:omg.org/CORBA/Object:1.0")) {
            try {
                String string2 = RepositoryID.className(stringArray[0], "Stub", null);
                int n = string2.lastIndexOf(46);
                StringBuffer stringBuffer = new StringBuffer(string2.substring(0, n + 1));
                stringBuffer.append('_');
                stringBuffer.append(string2.substring(n + 1));
                Class clazz = null;
                try {
                    clazz = ObjectUtil.classForName(stringBuffer.toString());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    clazz = ObjectUtil.classForName("org.omg.stub." + stringBuffer.toString());
                }
                Method method = clazz.getMethod("_ids", null);
                String[] stringArray2 = (String[])method.invoke(clazz.newInstance(), (java.lang.Object[])null);
                for (int i = 0; i < stringArray2.length; ++i) {
                    if (!stringArray2[i].equals(string)) continue;
                    return true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (SystemException systemException) {
                // empty catch block
            }
            this.logger.debug("trying is_a remotely");
        }
        while (true) {
            try {
                OutputStream outputStream = this.request(object, "_is_a", true);
                outputStream.write_string(string);
                InputStream inputStream = this.invoke(object, outputStream);
                return inputStream.read_boolean();
            }
            catch (RemarshalException remarshalException) {
                continue;
            }
            break;
        }
        catch (ApplicationException applicationException) {
            throw new INTERNAL("Unexpected exception " + applicationException.getId());
        }
    }

    public boolean is_equivalent(Object object, Object object2) {
        this.checkORB();
        boolean bl = true;
        if (object != object2) {
            ParsedIOR parsedIOR = new ParsedIOR(this.orb, object2.toString());
            ParsedIOR parsedIOR2 = new ParsedIOR(this.orb, object.toString());
            bl = parsedIOR2.getIDString().equals(parsedIOR.getIDString());
        }
        return bl;
    }

    public String getIDString() {
        return this.getParsedIOR().getIDString();
    }

    public boolean is_local(Object object) {
        if (ignoreNextCallToIsLocal.get() == Boolean.TRUE) {
            ignoreNextCallToIsLocal.set(Boolean.FALSE);
            return false;
        }
        if (localInterceptors.get() == null && this.orb.hasRequestInterceptors()) {
            return false;
        }
        return this.is_really_local(object);
    }

    private boolean is_really_local(Object object) {
        if (this.poa == null) {
            this.resolvePOA(object);
        }
        return this.poa != null;
    }

    public boolean is_nil() {
        ParsedIOR parsedIOR = this.getParsedIOR();
        return parsedIOR.getIOR().type_id.equals("") && parsedIOR.getIOR().profiles.length == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean non_existent(Object object) {
        if (this.is_really_local(object)) {
            ServantObject servantObject = this.servant_preinvoke(object, "_non_existent", java.lang.Object.class);
            try {
                Servant servant = (Servant)servantObject.servant;
                this.orb.set_delegate(servant);
                boolean bl = servant._non_existent();
                return bl;
            }
            finally {
                this.servant_postinvoke(object, servantObject);
            }
        }
        while (true) {
            try {
                OutputStream outputStream = this.request(object, "_non_existent", true);
                InputStream inputStream = this.invoke(object, outputStream);
                return inputStream.read_boolean();
            }
            catch (RemarshalException remarshalException) {
                continue;
            }
            break;
        }
        catch (ApplicationException applicationException) {
            throw new INTERNAL("Unexpected exception " + applicationException.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object get_component(Object object) {
        if (this.is_really_local(object)) {
            ServantObject servantObject = this.servant_preinvoke(object, "_get_component", java.lang.Object.class);
            try {
                Servant servant = (Servant)servantObject.servant;
                this.orb.set_delegate(servant);
                Object object2 = servant._get_component();
                return object2;
            }
            finally {
                this.servant_postinvoke(object, servantObject);
            }
        }
        while (true) {
            try {
                OutputStream outputStream = this.request(object, "_get_component", true);
                InputStream inputStream = this.invoke(object, outputStream);
                return inputStream.read_Object();
            }
            catch (RemarshalException remarshalException) {
                continue;
            }
            break;
        }
        catch (ApplicationException applicationException) {
            throw new INTERNAL("Unexpected exception " + applicationException.getId());
        }
    }

    public org.omg.CORBA.ORB orb(Object object) {
        return this.orb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Object object) {
        java.lang.Object object2 = this.bind_sync;
        synchronized (object2) {
            if (!this.bound) {
                return;
            }
            if (this.connection != null) {
                this.conn_mg.releaseConnection(this.connection);
                this.connection = null;
            }
            this.bound = false;
            this.orb._release(this.getParsedIOR().getIORString());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Delegate released!");
            }
        }
    }

    public void releaseReply(Object object, InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Time.waitFor(this.getReplyStartTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.omg.CORBA.Request request(Object object, String string) {
        this.orb.perform_work();
        java.lang.Object object2 = this.bind_sync;
        synchronized (object2) {
            this.bind();
            return new Request(object, this.orb, this.connection, this.getParsedIOR().get_object_key(), string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized OutputStream request(Object object, String string, boolean bl) {
        this.orb.perform_work();
        UtcT utcT = this.getRequestEndTime();
        long l = this.getRelativeRequestTimeout();
        if ((l != 0L || utcT != null) && Time.hasPassed(utcT = Time.earliest(Time.corbaFuture(l), utcT))) {
            throw new TIMEOUT("Request End Time exceeded prior to invocation", 0, CompletionStatus.COMPLETED_NO);
        }
        UtcT utcT2 = this.getReplyEndTime();
        long l2 = this.getRelativeRoundtripTimeout();
        if ((l2 != 0L || utcT2 != null) && Time.hasPassed(utcT2 = Time.earliest(Time.corbaFuture(l2), utcT2))) {
            throw new TIMEOUT("Reply End Time exceeded prior to invocation", 0, CompletionStatus.COMPLETED_NO);
        }
        java.lang.Object object2 = this.bind_sync;
        synchronized (object2) {
            this.bind();
            ParsedIOR parsedIOR = this.getParsedIOR();
            RequestOutputStream requestOutputStream = new RequestOutputStream(this.orb, this.connection, this.connection.getId(), string, bl, this.getSyncScope(), this.getRequestStartTime(), utcT, utcT2, parsedIOR.get_object_key(), parsedIOR.getEffectiveProfile().version().minor);
            requestOutputStream.configure(this.configuration);
            if (!this.connection.isTCSNegotiated()) {
                this.connection.setCodeSet(parsedIOR);
            }
            requestOutputStream.setCodeSets(this.connection.getTCS(), this.connection.getTCSW());
            requestOutputStream.updateMutatorConnection(this.connection.getGIOPConnection());
            return requestOutputStream;
        }
    }

    public void servant_postinvoke(Object object, ServantObject servantObject) {
        if (this.poa != null) {
            block4: {
                if (this.poa.isUseServantManager() && !this.poa.isRetain() && this.cookie != null && this.invokedOperation != null) {
                    try {
                        byte[] byArray = POAUtil.extractOID(this.getParsedIOR().get_object_key());
                        ServantLocator servantLocator = (ServantLocator)this.poa.get_servant_manager();
                        servantLocator.postinvoke(byArray, this.poa, this.invokedOperation, this.cookie.value, (Servant)servantObject.servant);
                        this.cookie = null;
                        this.invokedOperation = null;
                    }
                    catch (Throwable throwable) {
                        if (!this.logger.isWarnEnabled()) break block4;
                        this.logger.warn(throwable.getMessage());
                    }
                }
            }
            this.poa.removeLocalRequest();
        }
        this.orb.getPOACurrent()._removeContext(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServantObject servant_preinvoke(Object object, String string, Class clazz) {
        if (this.poa == null) {
            this.resolvePOA(object);
        }
        if (this.poa != null) {
            ServantObject servantObject;
            block20: {
                this.poa.addLocalRequest();
                servantObject = new ServantObject();
                try {
                    if (this.poa.isRetain() && !this.poa.isUseServantManager() || this.poa.useDefaultServant()) {
                        try {
                            servantObject.servant = this.poa.reference_to_servant(object);
                            break block20;
                        }
                        catch (WrongAdapter wrongAdapter) {
                            this.poa.removeLocalRequest();
                            throw new OBJ_ADAPTER("WrongAdapter caught when converting servant to reference. " + wrongAdapter);
                        }
                        catch (WrongPolicy wrongPolicy) {
                            this.poa.removeLocalRequest();
                            throw new OBJ_ADAPTER("WrongPolicy caught" + wrongPolicy);
                        }
                        catch (ObjectNotActive objectNotActive) {
                            this.poa.removeLocalRequest();
                            throw new OBJECT_NOT_EXIST();
                        }
                    }
                    if (this.poa.isUseServantManager()) {
                        byte[] byArray = POAUtil.extractOID(this.getParsedIOR().get_object_key());
                        ServantManager servantManager = this.poa.get_servant_manager();
                        if (this.poa.isRetain()) {
                            servantObject.servant = this.poa._incarnateServant(byArray, (ServantActivator)servantManager);
                            break block20;
                        }
                        ServantLocator servantLocator = (ServantLocator)servantManager;
                        this.cookie = new CookieHolder();
                        this.invokedOperation = string;
                        boolean bl = false;
                        try {
                            servantObject.servant = servantLocator.preinvoke(byArray, this.poa, string, this.cookie);
                            bl = true;
                            break block20;
                        }
                        finally {
                            if (!bl) {
                                this.poa.removeLocalRequest();
                            }
                        }
                    }
                    throw new INTERNAL("Internal error: we should not have gotten to this piece of code!");
                }
                catch (WrongPolicy wrongPolicy) {
                    this.poa.removeLocalRequest();
                    throw new OBJ_ADAPTER("WrongPolicy caught" + wrongPolicy);
                }
                catch (org.omg.PortableServer.ForwardRequest forwardRequest) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Caught forwardrequest to " + forwardRequest.forward_reference + " from " + object);
                    }
                    return this.servant_preinvoke(forwardRequest.forward_reference, string, clazz);
                }
            }
            if (!clazz.isInstance(servantObject.servant)) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Expected " + clazz + " got " + servantObject.servant.getClass());
                }
                ignoreNextCallToIsLocal.set(Boolean.TRUE);
                this.poa.removeLocalRequest();
                return null;
            }
            this.orb.getPOACurrent()._addContext(Thread.currentThread(), new LocalInvocationContext(this.orb, this.poa, this.getObjectId(), (Servant)servantObject.servant));
            return servantObject;
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("No POA! servant_preinvoke returns null");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        java.lang.Object object = this.bind_sync;
        synchronized (object) {
            if (this.piorOriginal != null) {
                return this.piorOriginal.getIORString();
            }
            return this.getParsedIOR().getIORString();
        }
    }

    public String toString(Object object) {
        return this.toString();
    }

    public String typeId() {
        return this.getParsedIOR().getIOR().type_id;
    }

    public Object set_policy_override(Object object, Policy[] policyArray, SetOverrideType setOverrideType) {
        if (this.policy_overrides == null) {
            this.policy_overrides = new HashMap();
        }
        if (setOverrideType == SetOverrideType.SET_OVERRIDE) {
            this.policy_overrides.clear();
        }
        for (int i = 0; i < policyArray.length; ++i) {
            this.policy_overrides.put(ObjectUtil.newInteger(policyArray[i].policy_type()), policyArray[i]);
        }
        return object;
    }

    public String get_codebase(Object object) {
        return this.getParsedIOR().getCodebaseComponent();
    }

    public Set get_pending_replies() {
        return this.pending_replies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replyDone(ReplyPlaceholder replyPlaceholder) {
        Set set = this.pending_replies;
        synchronized (set) {
            this.pending_replies.remove(replyPlaceholder);
        }
    }

    public void lockBarrier() {
        this.pending_replies_sync.lockBarrier();
    }

    public void waitOnBarrier() {
        this.pending_replies_sync.waitOnBarrier();
    }

    public void openBarrier() {
        this.pending_replies_sync.openBarrier();
    }

    private void checkORB() {
        this.orb.work_pending();
    }

    private static class Barrier {
        private boolean is_open = true;

        private Barrier() {
        }

        public synchronized void waitOnBarrier() {
            while (!this.is_open) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public synchronized void lockBarrier() {
            this.is_open = false;
        }

        public synchronized void openBarrier() {
            this.is_open = true;
            this.notifyAll();
        }
    }
}

