/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import java.util.concurrent.ScheduledFuture;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.MessageSupplier;

public class PullMessagesUtility {
    private ScheduledFuture taskId_;
    private long interval_;
    private final TaskProcessor taskProcessor_;
    private final Runnable timerJob_;

    public PullMessagesUtility(final TaskProcessor taskProcessor, final MessageSupplier messageSupplier) {
        this.taskProcessor_ = taskProcessor;
        this.timerJob_ = new Runnable(){

            public void run() {
                taskProcessor.scheduleTimedPullTask(messageSupplier);
            }
        };
    }

    public synchronized void startTask(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Interval " + l + " must be > 0");
        }
        if (this.taskId_ == null) {
            this.taskId_ = this.taskProcessor_.executeTaskPeriodically(l, this.timerJob_, true);
            this.interval_ = l;
        }
    }

    public synchronized void stopTask() {
        if (this.taskId_ != null) {
            this.taskId_.cancel(true);
            this.taskId_ = null;
        }
    }

    public synchronized void restartTask(long l) {
        if (this.taskId_ == null) {
            throw new IllegalStateException("Not started");
        }
        if (this.interval_ != l) {
            this.stopTask();
            this.startTask(l);
        }
    }
}

