/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.jmx.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.jboss.logging.Logger;
import org.jboss.osgi.jmx.ObjectNameFactory;
import org.jboss.osgi.jmx.ServiceStateMBeanExt;
import org.jboss.osgi.jmx.internal.AbstractState;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ServiceStateExt
extends AbstractState
implements ServiceStateMBeanExt {
    private static final Logger log = Logger.getLogger(ServiceStateExt.class);

    public ServiceStateExt(BundleContext context, MBeanServer mbeanServer) {
        super(context, mbeanServer);
    }

    @Override
    ObjectName getObjectName() {
        return ObjectNameFactory.create("jboss.osgi:service=jmx,type=ServiceState");
    }

    @Override
    StandardMBean getStandardMBean() throws NotCompliantMBeanException {
        return new StandardMBean(this, ServiceStateMBeanExt.class);
    }

    @Override
    public CompositeData getService(String clazz) throws IOException {
        ServiceReference sref;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("getService: " + clazz));
        }
        if ((sref = this.context.getServiceReference(clazz)) == null) {
            if (trace) {
                log.trace((Object)"Cannot find service");
            }
            return null;
        }
        CompositeDataSupport compData = this.getCompositeData(sref);
        if (trace) {
            log.trace((Object)("Found service: " + compData));
        }
        return compData;
    }

    @Override
    public TabularData getServices(String clazz, String filter) throws IOException {
        ServiceReference[] srefs;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("getServices [clazz=" + clazz + ",filter=" + filter + "]"));
        }
        try {
            srefs = this.context.getServiceReferences(clazz, filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Invalid filter syntax: " + filter);
        }
        if (srefs == null) {
            if (trace) {
                log.trace((Object)"Cannot find services");
            }
            return null;
        }
        TabularDataSupport tabularData = new TabularDataSupport(SERVICES_TYPE);
        for (ServiceReference sref : srefs) {
            CompositeDataSupport compData = this.getCompositeData(sref);
            tabularData.put(compData.get("Identifier"), compData);
            if (!trace) continue;
            log.trace((Object)("Added service: " + compData));
        }
        return tabularData;
    }

    private CompositeDataSupport getCompositeData(ServiceReference sref) throws IOException {
        CompositeDataSupport compData;
        Long serviceId = (Long)sref.getProperty("service.id");
        ArrayList<Long> usingIdentifiers = new ArrayList<Long>();
        Bundle[] usingBundles = sref.getUsingBundles();
        if (usingBundles != null) {
            for (Bundle aux : usingBundles) {
                usingIdentifiers.add(aux.getBundleId());
            }
        }
        Long[] usingArr = usingIdentifiers.toArray(new Long[usingIdentifiers.size()]);
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("BundleIdentifier", sref.getBundle().getBundleId());
        items.put("Identifier", serviceId);
        items.put("objectClass", sref.getProperty("objectClass"));
        items.put("UsingBundles", usingArr);
        try {
            compData = new CompositeDataSupport(SERVICE_TYPE, items);
        }
        catch (OpenDataException ex) {
            throw new IllegalStateException(ex);
        }
        return compData;
    }

    public long getBundleIdentifier(long serviceId) throws IOException {
        long bundleId = this.getServiceStateMBean().getBundleIdentifier(serviceId);
        if (log.isTraceEnabled()) {
            log.trace((Object)("getBundleIdentifier [serviceId=" + serviceId + "] => " + bundleId));
        }
        return bundleId;
    }

    public String[] getObjectClass(long serviceId) throws IOException {
        String[] objectClass = this.getServiceStateMBean().getObjectClass(serviceId);
        if (log.isTraceEnabled()) {
            log.trace((Object)("getObjectClass [serviceId=" + serviceId + "] => " + (objectClass != null ? Arrays.asList(objectClass) : null)));
        }
        return objectClass;
    }

    public TabularData getProperties(long serviceId) throws IOException {
        TabularData properties = this.getServiceStateMBean().getProperties(serviceId);
        if (log.isTraceEnabled()) {
            log.trace((Object)("getProperties [serviceId=" + serviceId + "] => " + properties));
        }
        return properties;
    }

    public long[] getUsingBundles(long serviceId) throws IOException {
        long[] usingBundles = this.getServiceStateMBean().getUsingBundles(serviceId);
        if (log.isTraceEnabled()) {
            log.trace((Object)("getUsingBundles [serviceId=" + serviceId + "] => " + (usingBundles != null ? Arrays.asList(new long[][]{usingBundles}) : null)));
        }
        return usingBundles;
    }

    public TabularData listServices() throws IOException {
        TabularData services = this.getServiceStateMBean().listServices();
        if (log.isTraceEnabled()) {
            log.trace((Object)("listServices: " + services));
        }
        return services;
    }
}

