/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.jmx.internal;

import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.jboss.logging.Logger;
import org.jboss.osgi.jmx.MBeanProxy;
import org.jboss.osgi.jmx.ObjectNameFactory;
import org.osgi.framework.BundleContext;
import org.osgi.jmx.framework.BundleStateMBean;
import org.osgi.jmx.framework.FrameworkMBean;
import org.osgi.jmx.framework.PackageStateMBean;
import org.osgi.jmx.framework.ServiceStateMBean;

abstract class AbstractState {
    private static final Logger log = Logger.getLogger(AbstractState.class);
    protected MBeanServer mbeanServer;
    protected BundleContext context;

    AbstractState(BundleContext context, MBeanServer mbeanServer) {
        if (context == null) {
            throw new IllegalArgumentException("Null BundleContext");
        }
        if (mbeanServer == null) {
            throw new IllegalArgumentException("Null MBeanServer");
        }
        if (context.getBundle().getBundleId() != 0L) {
            throw new IllegalArgumentException("Not the system bundle context: " + context);
        }
        this.context = context;
        this.mbeanServer = mbeanServer;
    }

    void start() {
        ObjectName objectName = this.getObjectName();
        try {
            log.debug((Object)("Register: " + objectName));
            this.mbeanServer.registerMBean(this.getStandardMBean(), objectName);
        }
        catch (JMException ex) {
            log.warn((Object)("Cannot register: " + objectName));
        }
    }

    void stop() {
        ObjectName objectName = this.getObjectName();
        try {
            if (this.mbeanServer.isRegistered(objectName)) {
                log.debug((Object)("Unregister: " + objectName));
                this.mbeanServer.unregisterMBean(objectName);
            }
        }
        catch (JMException ex) {
            log.warn((Object)("Cannot unregister: " + objectName));
        }
    }

    abstract StandardMBean getStandardMBean() throws NotCompliantMBeanException;

    abstract ObjectName getObjectName();

    FrameworkMBean getFrameworkMBean() {
        ObjectName objectName = ObjectNameFactory.create("osgi.core:type=framework,version=1.5");
        return MBeanProxy.get(this.mbeanServer, objectName, FrameworkMBean.class);
    }

    BundleStateMBean getBundleStateMBean() {
        ObjectName objectName = ObjectNameFactory.create("osgi.core:type=bundleState,version=1.5");
        return MBeanProxy.get(this.mbeanServer, objectName, BundleStateMBean.class);
    }

    ServiceStateMBean getServiceStateMBean() {
        ObjectName objectName = ObjectNameFactory.create("osgi.core:type=serviceState,version=1.5");
        return MBeanProxy.get(this.mbeanServer, objectName, ServiceStateMBean.class);
    }

    PackageStateMBean getPackageStateMBean() {
        ObjectName objectName = ObjectNameFactory.create("osgi.core:type=packageState,version=1.5");
        return MBeanProxy.get(this.mbeanServer, objectName, PackageStateMBean.class);
    }
}

