/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.PackageAttribute;
import org.jboss.osgi.metadata.Parameter;
import org.jboss.osgi.metadata.ParameterizedAttribute;
import org.jboss.osgi.resolver.XBundleCapability;
import org.jboss.osgi.resolver.XFragmentHostRequirement;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.resolver.XModuleBuilder;
import org.jboss.osgi.resolver.XModuleIdentity;
import org.jboss.osgi.resolver.XPackageCapability;
import org.jboss.osgi.resolver.XPackageRequirement;
import org.jboss.osgi.resolver.XRequireBundleRequirement;
import org.jboss.osgi.resolver.spi.AbstractBundleCapability;
import org.jboss.osgi.resolver.spi.AbstractBundleRequirement;
import org.jboss.osgi.resolver.spi.AbstractDynamicPackageRequirement;
import org.jboss.osgi.resolver.spi.AbstractFragmentHostRequirement;
import org.jboss.osgi.resolver.spi.AbstractModule;
import org.jboss.osgi.resolver.spi.AbstractModuleIdentity;
import org.jboss.osgi.resolver.spi.AbstractPackageCapability;
import org.jboss.osgi.resolver.spi.AbstractPackageRequirement;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class AbstractModuleBuilder
implements XModuleBuilder {
    private AbstractModule module;

    public XModuleBuilder createModule(OSGiMetaData metadata, int revision) throws BundleException {
        AbstractModuleIdentity moduleId = new AbstractModuleIdentity(metadata, revision);
        this.module = new AbstractModule(moduleId);
        this.load(metadata);
        return this;
    }

    public XModuleBuilder createModule(String name, Version version, int revision) {
        AbstractModuleIdentity moduleId = new AbstractModuleIdentity(name, version, revision);
        this.module = new AbstractModule(moduleId);
        return this;
    }

    public XModuleIdentity getModuleIdentity() {
        this.assertModuleCreated();
        return this.module.getModuleId();
    }

    public XBundleCapability addBundleCapability(String symbolicName, Version version) {
        this.assertModuleCreated();
        AbstractBundleCapability cap = new AbstractBundleCapability(this.module, symbolicName, version);
        this.module.addCapability(cap);
        return cap;
    }

    public XRequireBundleRequirement addBundleRequirement(String symbolicName, Map<String, String> dirs, Map<String, Object> atts) {
        this.assertModuleCreated();
        AbstractBundleRequirement req = new AbstractBundleRequirement(this.module, symbolicName, dirs, atts);
        this.module.addRequirement(req);
        return req;
    }

    public XFragmentHostRequirement addFragmentHostRequirement(String symbolicName, Map<String, String> dirs, Map<String, Object> atts) {
        this.assertModuleCreated();
        AbstractFragmentHostRequirement req = new AbstractFragmentHostRequirement(this.module, symbolicName, dirs, atts);
        this.module.addRequirement(req);
        return req;
    }

    public XPackageCapability addPackageCapability(String name, Map<String, String> dirs, Map<String, Object> atts) {
        this.assertModuleCreated();
        AbstractPackageCapability cap = new AbstractPackageCapability(this.module, name, dirs, atts);
        this.module.addCapability(cap);
        return cap;
    }

    public XPackageRequirement addPackageRequirement(String name, Map<String, String> dirs, Map<String, Object> atts) {
        this.assertModuleCreated();
        AbstractPackageRequirement req = new AbstractPackageRequirement(this.module, name, dirs, atts);
        this.module.addRequirement(req);
        return req;
    }

    public XPackageRequirement addDynamicPackageRequirement(String name, Map<String, Object> atts) {
        this.assertModuleCreated();
        AbstractDynamicPackageRequirement req = new AbstractDynamicPackageRequirement(this.module, name, null, atts);
        this.module.addRequirement(req);
        return req;
    }

    public XModuleBuilder addBundleClassPath(String ... paths) {
        this.assertModuleCreated();
        this.module.addBundleClassPath(paths);
        return this;
    }

    public XModuleBuilder addModuleActivator(String moduleActivator) {
        this.assertModuleCreated();
        this.module.setModuleActivator(moduleActivator);
        return this;
    }

    public XModule getModule() {
        return this.module;
    }

    private void load(OSGiMetaData metadata) throws BundleException {
        try {
            List classPath;
            ParameterizedAttribute fragmentHost;
            List dynamicImports;
            Map<String, Object> atts;
            Map<String, String> dirs;
            List imports;
            List exports;
            XModuleIdentity moduleId = this.module.getModuleId();
            this.addBundleCapability(moduleId.getName(), moduleId.getVersion());
            this.addModuleActivator(metadata.getBundleActivator());
            List requireBundles = metadata.getRequireBundles();
            if (requireBundles != null && !requireBundles.isEmpty()) {
                for (ParameterizedAttribute attribs : requireBundles) {
                    String name = attribs.getAttribute();
                    Map<String, String> dirs2 = this.getDirectives(attribs);
                    Map<String, Object> atts2 = this.getAttributes(attribs);
                    this.addBundleRequirement(name, dirs2, atts2);
                }
            }
            if ((exports = metadata.getExportPackages()) != null && !exports.isEmpty()) {
                for (PackageAttribute attribs : exports) {
                    String name = attribs.getAttribute();
                    Map<String, String> dirs3 = this.getDirectives((ParameterizedAttribute)attribs);
                    Map<String, Object> atts3 = this.getAttributes((ParameterizedAttribute)attribs);
                    this.addPackageCapability(name, dirs3, atts3);
                }
            }
            if ((imports = metadata.getImportPackages()) != null && !imports.isEmpty()) {
                for (PackageAttribute attribs : imports) {
                    String name = attribs.getAttribute();
                    dirs = this.getDirectives((ParameterizedAttribute)attribs);
                    atts = this.getAttributes((ParameterizedAttribute)attribs);
                    this.addPackageRequirement(name, dirs, atts);
                }
            }
            if ((dynamicImports = metadata.getDynamicImports()) != null && !dynamicImports.isEmpty()) {
                for (PackageAttribute attribs : dynamicImports) {
                    String name = attribs.getAttribute();
                    atts = this.getAttributes((ParameterizedAttribute)attribs);
                    this.addDynamicPackageRequirement(name, atts);
                }
            }
            if ((fragmentHost = metadata.getFragmentHost()) != null) {
                String hostName = fragmentHost.getAttribute();
                dirs = this.getDirectives(fragmentHost);
                atts = this.getAttributes(fragmentHost);
                this.addFragmentHostRequirement(hostName, dirs, atts);
            }
            if ((classPath = metadata.getBundleClassPath()) != null && !classPath.isEmpty()) {
                this.addBundleClassPath(classPath.toArray(new String[classPath.size()]));
            }
        }
        catch (RuntimeException ex) {
            throw new BundleException("Cannot initialize XModule from: " + metadata, (Throwable)ex);
        }
    }

    private void assertModuleCreated() {
        if (this.module == null) {
            throw new IllegalStateException("Module not created");
        }
    }

    private Map<String, String> getDirectives(ParameterizedAttribute attribs) {
        HashMap<String, String> dirs = new HashMap<String, String>();
        for (String key : attribs.getDirectives().keySet()) {
            Parameter param = attribs.getDirective(key);
            dirs.put(key.trim(), param.getValue().toString().trim());
        }
        return dirs;
    }

    private Map<String, Object> getAttributes(ParameterizedAttribute attribs) {
        HashMap<String, Object> atts = new HashMap<String, Object>();
        for (String key : attribs.getAttributes().keySet()) {
            Parameter param = attribs.getAttribute(key);
            atts.put(key.trim(), param.getValue().toString().trim());
        }
        return atts;
    }
}

