/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.osgi.resolver.XAttachmentSupport;
import org.jboss.osgi.resolver.XBundleCapability;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XFragmentHostRequirement;
import org.jboss.osgi.resolver.XModule;
import org.jboss.osgi.resolver.XModuleIdentity;
import org.jboss.osgi.resolver.XPackageCapability;
import org.jboss.osgi.resolver.XPackageRequirement;
import org.jboss.osgi.resolver.XRequireBundleRequirement;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XResolver;
import org.jboss.osgi.resolver.XWire;
import org.jboss.osgi.resolver.spi.AbstractElement;
import org.jboss.osgi.resolver.spi.AbstractWire;
import org.osgi.framework.Version;

public class AbstractModule
extends AbstractElement
implements XModule {
    private XResolver resolver;
    private XModuleIdentity moduleId;
    private String moduleActivator;
    private XBundleCapability bundleCapability;
    private List<XCapability> capabilities;
    private List<XRequirement> requirements;
    private List<String> classPaths;
    private XFragmentHostRequirement hostRequirement;
    private XAttachmentSupport attachments;
    private List<XWire> wires;
    private boolean resolved;

    AbstractModule(XModuleIdentity moduleId) {
        super(moduleId.getName());
        this.moduleId = moduleId;
    }

    public XResolver getResolver() {
        return this.resolver;
    }

    void setResolver(XResolver resolver) {
        this.resolver = resolver;
    }

    public XModuleIdentity getModuleId() {
        return this.moduleId;
    }

    public Version getVersion() {
        return this.moduleId.getVersion();
    }

    public String getModuleActivator() {
        return this.moduleActivator;
    }

    void setModuleActivator(String moduleActivator) {
        this.moduleActivator = moduleActivator;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    void setResolved() {
        this.resolved = true;
    }

    public List<XCapability> getCapabilities() {
        if (this.capabilities == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.capabilities);
    }

    public List<XRequirement> getRequirements() {
        if (this.requirements == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.requirements);
    }

    public List<XRequireBundleRequirement> getBundleRequirements() {
        if (this.requirements == null) {
            return Collections.emptyList();
        }
        ArrayList<XRequireBundleRequirement> result = new ArrayList<XRequireBundleRequirement>();
        for (XRequirement aux : this.requirements) {
            if (!(aux instanceof XRequireBundleRequirement)) continue;
            result.add((XRequireBundleRequirement)aux);
        }
        return Collections.unmodifiableList(result);
    }

    public XBundleCapability getBundleCapability() {
        return this.bundleCapability;
    }

    public List<XPackageCapability> getPackageCapabilities() {
        if (this.capabilities == null) {
            return Collections.emptyList();
        }
        ArrayList<XPackageCapability> result = new ArrayList<XPackageCapability>();
        for (XCapability aux : this.capabilities) {
            if (!(aux instanceof XPackageCapability)) continue;
            XPackageCapability packcap = (XPackageCapability)aux;
            result.add(packcap);
        }
        return Collections.unmodifiableList(result);
    }

    public List<XPackageRequirement> getPackageRequirements() {
        if (this.requirements == null) {
            return Collections.emptyList();
        }
        ArrayList<XPackageRequirement> result = new ArrayList<XPackageRequirement>();
        for (XRequirement aux : this.requirements) {
            XPackageRequirement packreq;
            if (!(aux instanceof XPackageRequirement) || (packreq = (XPackageRequirement)aux).isDynamic()) continue;
            result.add(packreq);
        }
        return Collections.unmodifiableList(result);
    }

    public List<XPackageRequirement> getDynamicPackageRequirements() {
        if (this.requirements == null) {
            return Collections.emptyList();
        }
        ArrayList<XPackageRequirement> result = new ArrayList<XPackageRequirement>();
        for (XRequirement aux : this.requirements) {
            XPackageRequirement packreq;
            if (!(aux instanceof XPackageRequirement) || !(packreq = (XPackageRequirement)aux).isDynamic()) continue;
            result.add(packreq);
        }
        return Collections.unmodifiableList(result);
    }

    public XFragmentHostRequirement getHostRequirement() {
        if (this.hostRequirement != null) {
            return this.hostRequirement;
        }
        if (this.requirements != null) {
            for (XRequirement aux : this.requirements) {
                if (!(aux instanceof XFragmentHostRequirement)) continue;
                this.hostRequirement = (XFragmentHostRequirement)aux;
                break;
            }
        }
        return this.hostRequirement;
    }

    public boolean isFragment() {
        return this.getHostRequirement() != null;
    }

    public List<String> getBundleClassPath() {
        if (this.classPaths == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.classPaths);
    }

    void addBundleClassPath(String ... paths) {
        if (this.classPaths == null) {
            this.classPaths = new ArrayList<String>();
        }
        this.classPaths.addAll(Arrays.asList(paths));
    }

    public List<XWire> getWires() {
        if (!this.resolved) {
            return null;
        }
        if (this.wires == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.wires);
    }

    protected void addWire(AbstractWire wire) {
        if (this.wires == null) {
            this.wires = new ArrayList<XWire>();
        }
        this.wires.add(wire);
    }

    void addCapability(XCapability capability) {
        if (this.capabilities == null) {
            this.capabilities = new ArrayList<XCapability>();
        }
        if (capability instanceof XBundleCapability) {
            this.bundleCapability = (XBundleCapability)capability;
        }
        this.capabilities.add(capability);
    }

    void addRequirement(XRequirement requirement) {
        if (this.requirements == null) {
            this.requirements = new ArrayList<XRequirement>();
        }
        this.requirements.add(requirement);
    }

    public <T> T addAttachment(Class<T> clazz, T value) {
        if (this.attachments == null) {
            this.attachments = new AbstractElement.AttachmentSupporter();
        }
        return (T)this.attachments.addAttachment(clazz, value);
    }

    public <T> T getAttachment(Class<T> clazz) {
        if (this.attachments == null) {
            return null;
        }
        return (T)this.attachments.getAttachment(clazz);
    }

    public <T> T removeAttachment(Class<T> clazz) {
        if (this.attachments == null) {
            return null;
        }
        return (T)this.attachments.removeAttachment(clazz);
    }

    public int hashCode() {
        return (this.getName() + ":" + this.getVersion()).hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AbstractModule)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        AbstractModule other = (AbstractModule)obj;
        return this.moduleId == other.moduleId;
    }

    public StringBuffer toLongString(StringBuffer buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException("Null buffer");
        }
        String simpleName = this.getClass().getSimpleName();
        buffer.append("\n" + simpleName + ": " + this.toString());
        if (this.resolved) {
            buffer.append(" - resolved");
        }
        buffer.append("\nCapabilities");
        for (XCapability cap : this.getCapabilities()) {
            buffer.append("\n " + cap);
        }
        buffer.append("\nRequirements");
        for (XRequirement req : this.getRequirements()) {
            buffer.append("\n " + req);
        }
        if (this.wires != null) {
            buffer.append("\nWires");
            for (XWire wire : this.getWires()) {
                buffer.append("\n " + wire);
            }
        }
        return buffer;
    }

    public String toString() {
        return "[" + this.getModuleId() + "]";
    }
}

