/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.deployment;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.DeploymentDescription;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.FileRepository;
import org.jboss.dmr.ModelNode;

public class ServerGroupDeploymentReplaceHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "replace-deployment";
    private final FileRepository fileRepository;
    private final ParametersValidator validator = new ParametersValidator();

    static final ModelNode getOperation(ModelNode address) {
        return Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)address);
    }

    public ServerGroupDeploymentReplaceHandler(FileRepository fileRepository) {
        if (fileRepository == null) {
            throw new IllegalArgumentException("fileRepository is null");
        }
        this.fileRepository = fileRepository;
        this.validator.registerValidator("name", (ParameterValidator)new StringLengthValidator(1));
        this.validator.registerValidator("to-replace", (ParameterValidator)new StringLengthValidator(1));
    }

    public ModelNode getModelDescription(Locale locale) {
        return DeploymentDescription.getDeployDeploymentOperation((Locale)locale);
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource domainDeployment;
        this.validator.validate(operation);
        String name = operation.require("name").asString();
        String toReplace = operation.require("to-replace").asString();
        if (name.equals(toReplace)) {
            throw ServerGroupDeploymentReplaceHandler.operationFailed(String.format("Cannot use %s with the same value for parameters %s and %s. Use %s to redeploy the same content or %s to replace content with a new version with the same name.", OPERATION_NAME, "name", "to-replace", "redeploy", "full-replace-deployment"));
        }
        PathElement deploymentPath = PathElement.pathElement((String)"deployment", (String)name);
        PathElement replacePath = PathElement.pathElement((String)"deployment", (String)toReplace);
        try {
            domainDeployment = context.getRootResource().requireChild(deploymentPath);
        }
        catch (Exception e) {
            throw ServerGroupDeploymentReplaceHandler.operationFailed(String.format("No deployment with name %s found", name));
        }
        ModelNode deployment = domainDeployment.getModel();
        for (ModelNode content : deployment.require("content").asList()) {
            if (!content.hasDefined("hash")) continue;
            byte[] hash = content.require("hash").asBytes();
            this.fileRepository.getDeploymentFiles(hash);
        }
        Resource serverGroup = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        if (!serverGroup.hasChild(replacePath)) {
            throw ServerGroupDeploymentReplaceHandler.operationFailed(String.format("No deployment with name %s found", toReplace));
        }
        Resource replaceResource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{replacePath}));
        if (!serverGroup.hasChild(deploymentPath)) {
            Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{deploymentPath}));
            ModelNode deployNode = resource.getModel();
            deployNode.set(deployment);
            deployNode.remove("content");
            deployNode.get("enabled").set(true);
        } else {
            Resource deploymentResource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{deploymentPath}));
            if (deploymentResource.getModel().get("enabled").asBoolean()) {
                throw ServerGroupDeploymentReplaceHandler.operationFailed(String.format("Deployment %s is already started", toReplace));
            }
        }
        replaceResource.getModel().get("enabled").set(false);
        context.completeStep();
    }

    private static OperationFailedException operationFailed(String msg) {
        return new OperationFailedException(new ModelNode().set(msg));
    }
}

