/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.operations.coordination;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.operations.coordination.ParsedOp;
import org.jboss.as.domain.controller.operations.coordination.PrepareStepHandler;
import org.jboss.as.domain.controller.operations.coordination.ServerOperationResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ServerOperationsResolverHandler
implements OperationStepHandler {
    public static final String OPERATION_NAME = "server-operation-resolver";
    private final String localHostName;
    private final ServerOperationResolver resolver;
    private final ParsedOp parsedOp;
    private final PathAddress originalAddress;
    private final ImmutableManagementResourceRegistration originalRegistration;
    private final ModelNode localResponse;
    private final boolean recordResponse;

    ServerOperationsResolverHandler(String localHostName, ServerOperationResolver resolver, ParsedOp parsedOp, PathAddress originalAddress, ImmutableManagementResourceRegistration originalRegistration, ModelNode response, boolean recordResponse) {
        this.localHostName = localHostName;
        this.resolver = resolver;
        this.parsedOp = parsedOp;
        this.originalAddress = originalAddress;
        this.originalRegistration = originalRegistration;
        this.localResponse = response;
        this.recordResponse = recordResponse;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.hasResult()) {
            this.localResponse.get("result").set(context.getResult());
        }
        if (context.hasFailureDescription()) {
            this.localResponse.get("failure-description").set(context.getFailureDescription());
            context.setRollbackOnly();
        } else {
            ModelNode responseNode;
            final ModelNode domainModel = Resource.Tools.readModel((Resource)context.getRootResource());
            ParsedOp.ServerOperationProvider provider = new ParsedOp.ServerOperationProvider(){

                @Override
                public Map<Set<ServerIdentity>, ModelNode> getServerOperations(ModelNode domainOp, PathAddress address) {
                    return ServerOperationsResolverHandler.this.getServerOperations(domainOp, address, domainModel, domainModel.get("host").get(ServerOperationsResolverHandler.this.localHostName));
                }
            };
            ModelNode localResult = this.localResponse.get("result");
            this.localResponse.remove("result");
            ModelNode modelNode = responseNode = this.recordResponse ? context.getResult() : this.localResponse.get("result");
            if (ModelType.STRING == localResult.getType() && "ignored-by-unaffected-host-controller".equals(localResult.asString())) {
                responseNode.set(localResult);
            } else {
                Map<Set<ServerIdentity>, ModelNode> serverOps = this.parsedOp.getServerOps(provider);
                this.createOverallResult(serverOps, localResult, responseNode);
            }
            if (PrepareStepHandler.isTraceEnabled()) {
                PrepareStepHandler.log.trace((Object)(this.getClass().getSimpleName() + " responseNode is " + responseNode));
            }
        }
        context.completeStep();
    }

    private Map<Set<ServerIdentity>, ModelNode> getServerOperations(ModelNode domainOp, PathAddress domainOpAddress, ModelNode domainModel, ModelNode hostModel) {
        Map<Set<ServerIdentity>, ModelNode> result = null;
        PathAddress relativeAddress = domainOpAddress.subAddress(this.originalAddress.size());
        Set flags = this.originalRegistration.getOperationFlags(relativeAddress, domainOp.require("operation").asString());
        if (flags.contains(OperationEntry.Flag.READ_ONLY)) {
            result = Collections.emptyMap();
        }
        if (result == null) {
            result = this.resolver.getServerOperations(domainOp, domainOpAddress, domainModel, hostModel);
        }
        return result;
    }

    private void createOverallResult(Map<Set<ServerIdentity>, ModelNode> serverOps, ModelNode localResult, ModelNode overallResult) {
        ModelNode domainResult = this.parsedOp.getFormattedDomainResult(localResult);
        overallResult.get("domain-results").set(domainResult);
        ModelNode serverOpsNode = overallResult.get("server-operations");
        for (Map.Entry<Set<ServerIdentity>, ModelNode> entry : serverOps.entrySet()) {
            ModelNode setNode = serverOpsNode.add();
            ModelNode serverNode = setNode.get("servers");
            serverNode.setEmptyList();
            for (ServerIdentity server : entry.getKey()) {
                serverNode.add(server.getServerName(), server.getServerGroupName());
            }
            setNode.get("operation").set(entry.getValue());
        }
    }
}

