/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ra.common;

import org.jboss.jca.common.api.metadata.JCAMetadata;
import org.jboss.jca.common.api.metadata.ra.OverrideElementAttribute;
import org.jboss.jca.common.api.metadata.ra.RaConfigProperty;

public class RaConfigPropertyImpl<T>
implements JCAMetadata,
RaConfigProperty<T> {
    private static final long serialVersionUID = 7845799671062777306L;
    private final String name;
    private final T value;
    private final String typeName;
    private final OverrideElementAttribute overrideElementAttribute;

    private RaConfigPropertyImpl(String name, T value, OverrideElementAttribute overrideElementAttribute) {
        this.name = name;
        this.value = value;
        this.typeName = value.getClass().getName();
        this.overrideElementAttribute = overrideElementAttribute == null ? OverrideElementAttribute.RESOURCE_ADAPTER : overrideElementAttribute;
    }

    private RaConfigPropertyImpl(String name, T value, String typeName, OverrideElementAttribute overrideElementAttribute) {
        this.name = name;
        this.value = value;
        this.typeName = typeName;
        this.overrideElementAttribute = overrideElementAttribute == null ? OverrideElementAttribute.RESOURCE_ADAPTER : overrideElementAttribute;
    }

    public static RaConfigProperty<?> buildRaConfigProperty(String name, String value, String type, OverrideElementAttribute overrideElementAttribute) throws NumberFormatException {
        if (type == null || type.trim().length() == 0) {
            return new RaConfigPropertyImpl<String>(name, value, overrideElementAttribute);
        }
        if ("java.lang.Boolean".equals(type)) {
            return new RaConfigPropertyImpl<Boolean>(name, Boolean.valueOf(value), overrideElementAttribute);
        }
        if ("java.lang.String".equals(type)) {
            return new RaConfigPropertyImpl<String>(name, value, overrideElementAttribute);
        }
        if ("java.lang.Integer".equals(type)) {
            return new RaConfigPropertyImpl<Integer>(name, Integer.valueOf(value), overrideElementAttribute);
        }
        if ("java.lang.Double".equals(type)) {
            return new RaConfigPropertyImpl<Double>(name, Double.valueOf(value), overrideElementAttribute);
        }
        if ("java.lang.Byte".equals(type)) {
            return new RaConfigPropertyImpl<Byte>(name, Byte.valueOf(value), overrideElementAttribute);
        }
        if ("java.lang.Long".equals(type)) {
            return new RaConfigPropertyImpl<Long>(name, Long.valueOf(value), overrideElementAttribute);
        }
        if ("java.lang.Float".equals(type)) {
            return new RaConfigPropertyImpl<Float>(name, Float.valueOf(value), overrideElementAttribute);
        }
        if ("java.lang.Character".equals(type)) {
            return new RaConfigPropertyImpl<Character>(name, Character.valueOf(value.charAt(0)), overrideElementAttribute);
        }
        return new RaConfigPropertyImpl<String>(name, value, type, overrideElementAttribute);
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized T getValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RaConfigPropertyImpl)) {
            return false;
        }
        RaConfigPropertyImpl other = (RaConfigPropertyImpl)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String toString() {
        return "RaConfigProperty [name=" + this.name + ", value=" + this.value + "]";
    }

    public String getTypeName() {
        return this.typeName;
    }

    public OverrideElementAttribute getOverrideElementAttribute() {
        return this.overrideElementAttribute;
    }
}

