/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.common;

import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.common.CommonTimeOut;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.logging.Messages;

public class CommonTimeOutImpl
implements CommonTimeOut {
    private static final long serialVersionUID = 7351813875143571341L;
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);
    protected final Long blockingTimeoutMillis;
    protected final Long idleTimeoutMinutes;
    protected final Integer allocationRetry;
    protected final Long allocationRetryWaitMillis;
    protected final Integer xaResourceTimeout;

    public CommonTimeOutImpl(Long blockingTimeoutMillis, Long idleTimeoutMinutes, Integer allocationRetry, Long allocationRetryWaitMillis, Integer xaResourceTimeout) throws ValidateException {
        this.blockingTimeoutMillis = blockingTimeoutMillis;
        this.idleTimeoutMinutes = idleTimeoutMinutes;
        this.allocationRetry = allocationRetry;
        this.allocationRetryWaitMillis = allocationRetryWaitMillis;
        this.xaResourceTimeout = xaResourceTimeout;
        this.partialCommonValidate();
    }

    public final Long getBlockingTimeoutMillis() {
        return this.blockingTimeoutMillis;
    }

    public final Long getIdleTimeoutMinutes() {
        return this.idleTimeoutMinutes;
    }

    public final Integer getAllocationRetry() {
        return this.allocationRetry;
    }

    public final Long getAllocationRetryWaitMillis() {
        return this.allocationRetryWaitMillis;
    }

    public Integer getXaResourceTimeout() {
        return this.xaResourceTimeout;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allocationRetry == null ? 0 : this.allocationRetry.hashCode());
        result = 31 * result + (this.allocationRetryWaitMillis == null ? 0 : this.allocationRetryWaitMillis.hashCode());
        result = 31 * result + (this.blockingTimeoutMillis == null ? 0 : this.blockingTimeoutMillis.hashCode());
        result = 31 * result + (this.idleTimeoutMinutes == null ? 0 : this.idleTimeoutMinutes.hashCode());
        result = 31 * result + (this.xaResourceTimeout == null ? 0 : this.xaResourceTimeout.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommonTimeOutImpl)) {
            return false;
        }
        CommonTimeOutImpl other = (CommonTimeOutImpl)obj;
        if (this.allocationRetry == null ? other.allocationRetry != null : !this.allocationRetry.equals(other.allocationRetry)) {
            return false;
        }
        if (this.allocationRetryWaitMillis == null ? other.allocationRetryWaitMillis != null : !this.allocationRetryWaitMillis.equals(other.allocationRetryWaitMillis)) {
            return false;
        }
        if (this.blockingTimeoutMillis == null ? other.blockingTimeoutMillis != null : !this.blockingTimeoutMillis.equals(other.blockingTimeoutMillis)) {
            return false;
        }
        if (this.idleTimeoutMinutes == null ? other.idleTimeoutMinutes != null : !this.idleTimeoutMinutes.equals(other.idleTimeoutMinutes)) {
            return false;
        }
        return !(this.xaResourceTimeout == null ? other.xaResourceTimeout != null : !this.xaResourceTimeout.equals(other.xaResourceTimeout));
    }

    public String toString() {
        return "CommonTimeOutImpl [blockingTimeoutMillis=" + this.blockingTimeoutMillis + ", idleTimeoutMinutes=" + this.idleTimeoutMinutes + ", allocationRetry=" + this.allocationRetry + ", allocationRetryWaitMillis=" + this.allocationRetryWaitMillis + ", xaResourceTimeout=" + this.xaResourceTimeout + "]";
    }

    private void partialCommonValidate() throws ValidateException {
        if (this.allocationRetry != null && this.allocationRetry < 0) {
            throw new ValidateException(bundle.invalidNegative(CommonTimeOut.Tag.ALLOCATIONRETRY.getLocalName()));
        }
        if (this.blockingTimeoutMillis != null && this.blockingTimeoutMillis < 0L) {
            throw new ValidateException(bundle.invalidNegative(CommonTimeOut.Tag.BLOCKINGTIMEOUTMILLIS.getLocalName()));
        }
        if (this.allocationRetryWaitMillis != null && this.allocationRetryWaitMillis < 0L) {
            throw new ValidateException(bundle.invalidNegative(CommonTimeOut.Tag.ALLOCATIONRETRYWAITMILLIS.getLocalName()));
        }
        if (this.idleTimeoutMinutes != null && this.idleTimeoutMinutes < 0L) {
            throw new ValidateException(bundle.invalidNegative(CommonTimeOut.Tag.IDLETIMEOUTMINUTES.getLocalName()));
        }
        if (this.xaResourceTimeout != null && this.xaResourceTimeout < 0) {
            throw new ValidateException(bundle.invalidNegative(CommonTimeOut.Tag.XARESOURCETIMEOUT.getLocalName()));
        }
    }
}

