/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.mw.wst11.client;

import com.arjuna.mw.wsc11.context.Context;
import com.arjuna.mw.wst.TxContext;
import com.arjuna.mw.wst.common.SOAPUtil;
import com.arjuna.mw.wst11.BusinessActivityManager;
import com.arjuna.mw.wst11.BusinessActivityManagerFactory;
import com.arjuna.mw.wst11.TransactionManager;
import com.arjuna.mw.wst11.TransactionManagerFactory;
import com.arjuna.mw.wst11.common.CoordinationContextHelper;
import com.arjuna.mw.wstx.logging.wstxLogger;
import com.arjuna.mwlabs.wst11.at.context.TxContextImple;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.CoordinationContextType;
import org.w3c.dom.Element;

class JaxBaseHeaderContextProcessor {
    JaxBaseHeaderContextProcessor() {
    }

    public boolean handleOutboundMessage(SOAPMessage soapMessage) {
        if (soapMessage == null) {
            return true;
        }
        try {
            com.arjuna.mwlabs.wst11.ba.context.TxContextImple txContext;
            TxContextImple txContext2;
            TransactionManager transactionManager = TransactionManagerFactory.transactionManager();
            BusinessActivityManager businessActivityManager = BusinessActivityManagerFactory.businessActivityManager();
            Context atContext = transactionManager != null ? ((txContext2 = (TxContextImple)transactionManager.currentTransaction()) == null ? null : txContext2.context()) : null;
            Context baContext = businessActivityManager != null ? ((txContext = (com.arjuna.mwlabs.wst11.ba.context.TxContextImple)businessActivityManager.currentTransaction()) == null ? null : txContext.context()) : null;
            Object coordinationContext = atContext != null ? atContext.getCoordinationContext() : (baContext != null ? baContext.getCoordinationContext() : null);
            if (coordinationContext != null) {
                SOAPEnvelope env = soapMessage.getSOAPPart().getEnvelope();
                SOAPHeader header = env.getHeader();
                if (header == null) {
                    header = env.addHeader();
                }
                Name name = env.createName("CoordinationContext", "wscoor", "http://docs.oasis-open.org/ws-tx/wscoor/2006/06");
                SOAPHeaderElement headerElement = header.addHeaderElement(name);
                headerElement.addNamespaceDeclaration("wscoor", "http://docs.oasis-open.org/ws-tx/wscoor/2006/06");
                headerElement.setMustUnderstand(true);
                CoordinationContextHelper.serialise((CoordinationContextType)coordinationContext, (Element)headerElement);
            }
        }
        catch (Throwable th) {
            wstxLogger.i18NLogger.warn_mw_wst11_client_JaxHC11P_1("com.arjuna.mw.wst11.client.JaxBaseHeaderContextProcessor.handleRequest()", th);
        }
        return true;
    }

    protected void resumeTransaction(SOAPMessage soapMessage) {
        if (soapMessage != null) {
            try {
                CoordinationContextType cc;
                SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
                SOAPHeaderElement soapHeaderElement = this.getHeaderElement(soapEnvelope, "http://docs.oasis-open.org/ws-tx/wscoor/2006/06", "CoordinationContext");
                if (soapHeaderElement != null && (cc = CoordinationContextHelper.deserialise((Element)soapHeaderElement)) != null) {
                    String coordinationType = cc.getCoordinationType();
                    if ("http://docs.oasis-open.org/ws-tx/wsat/2006/06".equals(coordinationType)) {
                        TxContextImple txContext = new TxContextImple(cc);
                        TransactionManagerFactory.transactionManager().resume((TxContext)txContext);
                    } else if ("http://docs.oasis-open.org/ws-tx/wsba/2006/06/AtomicOutcome".equals(coordinationType)) {
                        com.arjuna.mwlabs.wst11.ba.context.TxContextImple txContext = new com.arjuna.mwlabs.wst11.ba.context.TxContextImple(cc);
                        BusinessActivityManagerFactory.businessActivityManager().resume((TxContext)txContext);
                    } else {
                        wstxLogger.i18NLogger.warn_mw_wst11_client_JaxHC11P_2("com.arjuna.mw.wst11.client.JaxBaseHeaderContextProcessor.resumeTransaction()", coordinationType);
                    }
                }
            }
            catch (Throwable th) {
                wstxLogger.i18NLogger.warn_mw_wst11_client_JaxHC11P_1("com.arjuna.mw.wst11.client.JaxBaseHeaderContextProcessor.resumeTransaction()", th);
            }
        }
    }

    private SOAPHeaderElement getHeaderElement(SOAPEnvelope soapEnvelope, String uri, String name) throws SOAPException {
        SOAPHeader soapHeader = soapEnvelope.getHeader();
        if (soapHeader != null) {
            Iterator headerIter = SOAPUtil.getChildElements((SOAPElement)soapHeader);
            while (headerIter.hasNext()) {
                SOAPHeaderElement current = (SOAPHeaderElement)headerIter.next();
                Name currentName = current.getElementName();
                if (currentName == null || !this.match(name, currentName.getLocalName()) || !this.match(uri, currentName.getURI())) continue;
                return current;
            }
        }
        return null;
    }

    private boolean match(Object lhs, Object rhs) {
        if (lhs == null) {
            return rhs == null;
        }
        return lhs.equals(rhs);
    }
}

