/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.process.processor.ejb.jboss;

import java.io.Externalizable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBean31MetaData;
import org.jboss.metadata.process.ProcessingException;
import org.jboss.metadata.process.processor.JBossMetaDataProcessor;

public class ImplicitNoInterfaceViewProcessor
implements JBossMetaDataProcessor<JBossMetaData> {
    private static Logger logger = Logger.getLogger(ImplicitNoInterfaceViewProcessor.class);
    private ClassLoader classLoader;

    public ImplicitNoInterfaceViewProcessor(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public JBossMetaData process(JBossMetaData metadata) throws ProcessingException {
        if (metadata == null) {
            return null;
        }
        if (!metadata.isEJB31()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Skipping metadata processing for: " + metadata + " since ejb version is " + metadata.getEjbVersion() + " - can only process 3.1 version"));
            }
            return metadata;
        }
        JBossEnterpriseBeansMetaData ejbs = metadata.getEnterpriseBeans();
        if (ejbs == null) {
            return metadata;
        }
        for (JBossEnterpriseBeanMetaData ejb : ejbs) {
            JBossSessionBean31MetaData jbossSessionBeanMetadata;
            if (!ejb.isSession() || !(ejb instanceof JBossSessionBean31MetaData) || (jbossSessionBeanMetadata = (JBossSessionBean31MetaData)ejb).isNoInterfaceBean() || !this.isEligibleForNoInterfaceView(jbossSessionBeanMetadata)) continue;
            jbossSessionBeanMetadata.setNoInterfaceBean(true);
        }
        return metadata;
    }

    private boolean isEligibleForNoInterfaceView(JBossSessionBean31MetaData jbossSessionBeanMetadata) throws ProcessingException {
        if (jbossSessionBeanMetadata.isNoInterfaceBean()) {
            return true;
        }
        String beanClassName = jbossSessionBeanMetadata.getEjbClass();
        if (jbossSessionBeanMetadata.getBusinessLocals() != null && !jbossSessionBeanMetadata.getBusinessLocals().isEmpty()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Bean " + beanClassName + " has business local, hence not eligible for no-interface view"));
            }
            return false;
        }
        if (jbossSessionBeanMetadata.getBusinessRemotes() != null && !jbossSessionBeanMetadata.getBusinessRemotes().isEmpty()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Bean " + beanClassName + " has business remote, hence not eligible for no-interface view"));
            }
            return false;
        }
        if (jbossSessionBeanMetadata.getHome() != null || jbossSessionBeanMetadata.getLocalHome() != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Bean " + beanClassName + " has 2.x home/local-home, hence not eligible for no-interface view"));
            }
            return false;
        }
        Class<?> ejbImplementationClass = null;
        try {
            ejbImplementationClass = Class.forName(beanClassName, false, this.classLoader);
            if (this.doesBeanImplementAnyInterfaces(ejbImplementationClass)) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Bean " + beanClassName + " implements interfaces (other than the one's excluded as per section 4.9.8 of EJB3.1 spec), hence not eligible for no-interface view"));
                }
                return false;
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            throw new ProcessingException("Could not load EJB Implementation Class " + beanClassName + " from the specified ClassLoader: " + this.classLoader);
        }
    }

    private boolean doesBeanImplementAnyInterfaces(Class<?> beanClass) {
        Class<?>[] interfaces = beanClass.getInterfaces();
        if (interfaces.length == 0) {
            return false;
        }
        ArrayList implementedInterfaces = new ArrayList(Arrays.asList(interfaces));
        Iterator implementedInterfacesIterator = implementedInterfaces.iterator();
        while (implementedInterfacesIterator.hasNext()) {
            Class implementedInterface = (Class)implementedInterfacesIterator.next();
            if (!implementedInterface.equals(Serializable.class) && !implementedInterface.equals(Externalizable.class) && !implementedInterface.getName().startsWith("javax.ejb.")) continue;
            implementedInterfacesIterator.remove();
        }
        return !implementedInterfaces.isEmpty();
    }
}

