/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.ejb.parser.spec;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.metadata.ejb.parser.spec.AbstractMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.AssemblyDescriptorMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.AssemblyDescriptorMetaDataParserFactory;
import org.jboss.metadata.ejb.parser.spec.EjbJarAttribute;
import org.jboss.metadata.ejb.parser.spec.EjbJarElement;
import org.jboss.metadata.ejb.parser.spec.EnterpriseBeansMetaDataParser;
import org.jboss.metadata.ejb.parser.spec.InterceptorsMetaDataParser;
import org.jboss.metadata.ejb.spec.EjbJar31MetaData;
import org.jboss.metadata.ejb.spec.EjbJar3xMetaData;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.ejb.spec.EjbJarVersion;
import org.jboss.metadata.ejb.spec.EnterpriseBeansMetaData;
import org.jboss.metadata.ejb.spec.InterceptorsMetaData;
import org.jboss.metadata.javaee.spec.DescriptionGroupMetaData;
import org.jboss.metadata.parser.ee.Accessor;
import org.jboss.metadata.parser.ee.DescriptionGroupMetaDataParser;

public abstract class AbstractEjbJarMetaDataParser<MD extends EjbJarMetaData>
extends AbstractMetaDataParser<MD> {
    @Override
    protected void processElement(final MD ejbJarMetaData, XMLStreamReader reader) throws XMLStreamException {
        EjbJarElement ejbJarElement = EjbJarElement.forName(reader.getLocalName());
        switch (ejbJarElement) {
            case MODULE_NAME: {
                if (((EjbJarMetaData)ejbJarMetaData).isEJB31() && ejbJarMetaData instanceof EjbJar31MetaData) {
                    String moduleName = AbstractEjbJarMetaDataParser.getElementText((XMLStreamReader)reader);
                    ((EjbJar31MetaData)ejbJarMetaData).setModuleName(moduleName);
                    break;
                }
                throw AbstractEjbJarMetaDataParser.unexpectedElement((XMLStreamReader)reader);
            }
            case ENTERPRISE_BEANS: {
                EnterpriseBeansMetaData enterpriseBeans = EnterpriseBeansMetaDataParser.parse(reader, ((EjbJarMetaData)ejbJarMetaData).getEjbJarVersion());
                if (enterpriseBeans != null) {
                    enterpriseBeans.setEjbJarMetaData((EjbJarMetaData)ejbJarMetaData);
                }
                ((EjbJarMetaData)ejbJarMetaData).setEnterpriseBeans(enterpriseBeans);
                break;
            }
            case INTERCEPTORS: {
                if (((EjbJarMetaData)ejbJarMetaData).isEJB3x() && ejbJarMetaData instanceof EjbJar3xMetaData) {
                    InterceptorsMetaData intercpetors = InterceptorsMetaDataParser.INSTANCE.parse(reader);
                    ((EjbJar3xMetaData)ejbJarMetaData).setInterceptors(intercpetors);
                    break;
                }
                throw AbstractEjbJarMetaDataParser.unexpectedElement((XMLStreamReader)reader);
            }
            case RELATIONSHIPS: {
                break;
            }
            case ASSEMBLY_DESCRIPTOR: {
                AssemblyDescriptorMetaDataParser assemblyDescriptorParser = AssemblyDescriptorMetaDataParserFactory.getParser(((EjbJarMetaData)ejbJarMetaData).getEjbJarVersion());
                ((EjbJarMetaData)ejbJarMetaData).setAssemblyDescriptor(assemblyDescriptorParser.parse(reader));
                break;
            }
            case EJB_CLIENT_JAR: {
                String ejbClientJar = AbstractEjbJarMetaDataParser.getElementText((XMLStreamReader)reader);
                ((EjbJarMetaData)ejbJarMetaData).setEjbClientJar(ejbClientJar);
                break;
            }
            default: {
                Accessor<DescriptionGroupMetaData> accessor = new Accessor<DescriptionGroupMetaData>(){

                    public DescriptionGroupMetaData get() {
                        DescriptionGroupMetaData descriptionGroup = ejbJarMetaData.getDescriptionGroup();
                        if (descriptionGroup == null) {
                            descriptionGroup = new DescriptionGroupMetaData();
                            ejbJarMetaData.setDescriptionGroup(descriptionGroup);
                        }
                        return descriptionGroup;
                    }
                };
                if (DescriptionGroupMetaDataParser.parse((XMLStreamReader)reader, (Accessor)accessor)) break;
                throw AbstractEjbJarMetaDataParser.unexpectedElement((XMLStreamReader)reader);
            }
        }
    }

    protected static EjbJarVersion readVersionAttribute(XMLStreamReader reader) throws XMLStreamException {
        EjbJarVersion ejbJarVersion = null;
        String versionString = null;
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            EjbJarAttribute ejbJarVersionAttribute;
            if (AbstractEjbJarMetaDataParser.attributeHasNamespace((XMLStreamReader)reader, (int)i) || (ejbJarVersionAttribute = EjbJarAttribute.forName(reader.getAttributeLocalName(i))) != EjbJarAttribute.VERSION) continue;
            versionString = reader.getAttributeValue(i);
        }
        if ("1.1".equals(versionString)) {
            ejbJarVersion = EjbJarVersion.EJB_1_1;
        } else if ("2.0".equals(versionString)) {
            ejbJarVersion = EjbJarVersion.EJB_2_0;
        } else if ("2.1".equals(versionString)) {
            ejbJarVersion = EjbJarVersion.EJB_2_1;
        } else if ("3.0".equals(versionString)) {
            ejbJarVersion = EjbJarVersion.EJB_3_0;
        } else if ("3.1".equals(versionString)) {
            ejbJarVersion = EjbJarVersion.EJB_3_1;
        }
        return ejbJarVersion;
    }
}

