/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.as.logging.AbstractFormatterSpec;
import org.jboss.logmanager.handlers.SizeRotatingFileHandler;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public final class SizeRotatingFileHandlerService
implements Service<Handler> {
    private final InjectedValue<String> fileName = new InjectedValue();
    private AbstractFormatterSpec formatterSpec;
    private Level level;
    private boolean autoflush;
    private String encoding;
    private boolean append;
    private int maxBackupIndex;
    private long rotateSize;
    private SizeRotatingFileHandler value;

    public synchronized void start(StartContext context) throws StartException {
        SizeRotatingFileHandler handler;
        this.value = handler = new SizeRotatingFileHandler();
        this.formatterSpec.apply((Handler)handler);
        if (this.level != null) {
            handler.setLevel(this.level);
        }
        handler.setAutoFlush(this.autoflush);
        try {
            handler.setEncoding(this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new StartException((Throwable)e);
        }
        handler.setAppend(this.append);
        try {
            handler.setFileName((String)this.fileName.getValue());
        }
        catch (FileNotFoundException e) {
            throw new StartException((Throwable)e);
        }
        handler.setMaxBackupIndex(this.maxBackupIndex);
        handler.setRotateSize(this.rotateSize);
    }

    public synchronized void stop(StopContext context) {
        SizeRotatingFileHandler handler = this.value;
        handler.close();
        this.value = null;
    }

    public synchronized Handler getValue() throws IllegalStateException {
        return this.value;
    }

    public synchronized Level getLevel() {
        return this.level;
    }

    public synchronized void setLevel(Level level) {
        this.level = level;
        SizeRotatingFileHandler handler = this.value;
        if (handler != null) {
            handler.setLevel(level);
        }
    }

    public synchronized AbstractFormatterSpec getFormatterSpec() {
        return this.formatterSpec;
    }

    public synchronized void setFormatterSpec(AbstractFormatterSpec formatterSpec) {
        this.formatterSpec = formatterSpec;
        SizeRotatingFileHandler handler = this.value;
        if (handler != null) {
            formatterSpec.apply((Handler)handler);
        }
    }

    public synchronized boolean isAutoflush() {
        return this.autoflush;
    }

    public synchronized void setAutoflush(boolean autoflush) {
        this.autoflush = autoflush;
        SizeRotatingFileHandler handler = this.value;
        if (handler != null) {
            handler.setAutoFlush(autoflush);
        }
    }

    public synchronized String getEncoding() {
        return this.encoding;
    }

    public synchronized void setEncoding(String encoding) throws UnsupportedEncodingException {
        SizeRotatingFileHandler handler = this.value;
        if (handler != null) {
            handler.setEncoding(encoding);
        }
        this.encoding = encoding;
    }

    public synchronized boolean isAppend() {
        return this.append;
    }

    public synchronized void setAppend(boolean append) {
        this.append = append;
        SizeRotatingFileHandler handler = this.value;
        if (handler != null) {
            handler.setAppend(append);
        }
    }

    public synchronized int getMaxBackupIndex() {
        return this.maxBackupIndex;
    }

    public synchronized void setMaxBackupIndex(int maxBackupIndex) {
        this.maxBackupIndex = maxBackupIndex;
        SizeRotatingFileHandler handler = this.value;
        if (handler != null) {
            handler.setMaxBackupIndex(maxBackupIndex);
        }
    }

    public synchronized long getRotateSize() {
        return this.rotateSize;
    }

    public synchronized void setRotateSize(long rotateSize) {
        this.rotateSize = rotateSize;
        SizeRotatingFileHandler handler = this.value;
        if (handler != null) {
            handler.setRotateSize(rotateSize);
        }
    }

    public Injector<String> getFileNameInjector() {
        return this.fileName;
    }
}

