/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.as.logging.AbstractFormatterSpec;
import org.jboss.as.logging.LogHandlerPropertiesConfigurator;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public final class CustomHandlerService
implements Service<Handler> {
    private static final Logger ROOT_LOGGER = Logger.getLogger((String)CustomHandlerService.class.getPackage().getName());
    private final String className;
    private final String moduleName;
    private final List<Property> properties;
    private AbstractFormatterSpec formatterSpec;
    private Level level;
    private String encoding;
    private Handler value;

    public CustomHandlerService(String className, String moduleName) {
        this.className = className;
        this.moduleName = moduleName;
        this.properties = new ArrayList<Property>();
    }

    public synchronized void start(StartContext context) throws StartException {
        Handler handler;
        ModuleLoader moduleLoader = Module.forClass(CustomHandlerService.class).getModuleLoader();
        ModuleIdentifier id = ModuleIdentifier.create((String)this.moduleName);
        try {
            Class<?> handlerClass = Class.forName(this.className, false, (ClassLoader)moduleLoader.loadModule(id).getClassLoader());
            if (!Handler.class.isAssignableFrom(handlerClass)) {
                throw new StartException(String.format("%s %s is not a valid %s.", "custom-handler", this.className, Handler.class.getName()));
            }
            handler = (Handler)handlerClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new StartException((Throwable)e);
        }
        catch (ModuleLoadException e) {
            throw new StartException(String.format("%s %s is not a valid %s.", "custom-handler", this.className, Handler.class.getName()), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new StartException(String.format("%s %s is not a valid %s.", "custom-handler", this.className, Handler.class.getName()), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new StartException(String.format("%s %s is not a valid %s.", "custom-handler", this.className, Handler.class.getName()), (Throwable)e);
        }
        this.formatterSpec.apply(handler);
        if (this.level != null) {
            handler.setLevel(this.level);
        }
        try {
            handler.setEncoding(this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new StartException((Throwable)e);
        }
        LogHandlerPropertiesConfigurator.setProperties(handler, this.properties);
        this.value = handler;
    }

    public synchronized void stop(StopContext context) {
        Handler handler = this.value;
        handler.close();
        this.properties.clear();
        this.value = null;
    }

    public synchronized void addProperty(Property property) {
        this.properties.add(property);
        Handler handler = this.value;
        if (handler != null) {
            LogHandlerPropertiesConfigurator.setProperties(handler, this.properties);
        }
    }

    public synchronized void addProperties(Collection<Property> properties) {
        this.properties.addAll(properties);
        Handler handler = this.value;
        if (handler != null) {
            LogHandlerPropertiesConfigurator.setProperties(handler, this.properties);
        }
    }

    public synchronized Handler getValue() throws IllegalStateException {
        return this.value;
    }

    public synchronized Level getLevel() {
        return this.level;
    }

    public synchronized void setLevel(Level level) {
        this.level = level;
        Handler handler = this.value;
        if (handler != null) {
            handler.setLevel(level);
        }
    }

    public synchronized AbstractFormatterSpec getFormatterSpec() {
        return this.formatterSpec;
    }

    public synchronized void setFormatterSpec(AbstractFormatterSpec formatterSpec) {
        this.formatterSpec = formatterSpec;
        Handler handler = this.value;
        if (handler != null) {
            formatterSpec.apply(handler);
        }
    }

    public synchronized String getEncoding() {
        return this.encoding;
    }

    public synchronized void setEncoding(String encoding) throws UnsupportedEncodingException {
        Handler handler = this.value;
        if (handler != null) {
            handler.setEncoding(encoding);
        }
        this.encoding = encoding;
    }
}

