/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import org.jboss.as.controller.AbstractModelUpdateHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.logging.AsyncHandlerService;
import org.jboss.as.logging.LogServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

public class AsyncHandlerUnassignSubhandler
extends AbstractModelUpdateHandler {
    private static final String OPERATION_NAME = "unassign-subhandler";
    private static final AsyncHandlerUnassignSubhandler INSTANCE = new AsyncHandlerUnassignSubhandler();

    public static String getOperationName() {
        return OPERATION_NAME;
    }

    public static AsyncHandlerUnassignSubhandler getInstance() {
        return INSTANCE;
    }

    protected void opFailed(String description) throws OperationFailedException {
        ModelNode failure = new ModelNode();
        failure.get(new String[]{"failure-description", description});
        throw new OperationFailedException(failure);
    }

    protected void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        ModelNode handlerNameNode = operation.get("name");
        String handlerName = handlerNameNode.asString();
        ModelNode assignedHandlers = model.get("subhandlers");
        if (!assignedHandlers.isDefined() || !assignedHandlers.asList().contains(handlerNameNode)) {
            this.opFailed("Can not unassign handler.  Handler " + handlerName + " is not assigned.");
        }
        ArrayList<ModelNode> newList = new ArrayList<ModelNode>();
        for (ModelNode node : assignedHandlers.asList()) {
            if (node.asString().equals(handlerName)) continue;
            newList.add(node);
        }
        model.get("subhandlers").set(newList);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String asyncHandlerName = address.getLastElement().getValue();
        String handlerNameToUnassign = operation.get("name").asString();
        ServiceRegistry serviceRegistry = context.getServiceRegistry(false);
        ServiceController asyncHandlerController = serviceRegistry.getService(LogServices.handlerName(asyncHandlerName));
        ServiceController handlerToUnassignController = serviceRegistry.getService(LogServices.handlerName(handlerNameToUnassign));
        AsyncHandlerService service = (AsyncHandlerService)asyncHandlerController.getService();
        Handler injectedHandler = (Handler)handlerToUnassignController.getService().getValue();
        service.removeHandler(injectedHandler);
    }
}

