/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.List;
import java.util.logging.Handler;
import org.jboss.as.controller.AbstractModelUpdateHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.logging.AsyncHandlerService;
import org.jboss.as.logging.LogServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.value.InjectedValue;

public class AsyncHandlerAssignSubhandler
extends AbstractModelUpdateHandler {
    private static final String OPERATION_NAME = "assign-subhandler";
    private static final AsyncHandlerAssignSubhandler INSTANCE = new AsyncHandlerAssignSubhandler();

    public static String getOperationName() {
        return OPERATION_NAME;
    }

    public static AsyncHandlerAssignSubhandler getInstance() {
        return INSTANCE;
    }

    protected void opFailed(String description) throws OperationFailedException {
        ModelNode failure = new ModelNode();
        failure.get(new String[]{"failure-description", description});
        throw new OperationFailedException(failure);
    }

    protected void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        String handlerName = operation.get("name").asString();
        ModelNode assignedHandlers = model.get("subhandlers");
        if (assignedHandlers.isDefined() && assignedHandlers.asList().contains(operation.get("name"))) {
            this.opFailed("Handler " + handlerName + " is already assigned.");
        }
        assignedHandlers.add(handlerName);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String asyncHandlerName = address.getLastElement().getValue();
        String handlerNameToAssign = operation.get("name").asString();
        ServiceRegistry serviceRegistry = context.getServiceRegistry(false);
        ServiceController asyncHandlerController = serviceRegistry.getService(LogServices.handlerName(asyncHandlerName));
        ServiceController handlerToAssignController = serviceRegistry.getService(LogServices.handlerName(handlerNameToAssign));
        if (handlerToAssignController == null) {
            this.opFailed("Handler " + handlerNameToAssign + " not found.");
        }
        AsyncHandlerService service = (AsyncHandlerService)asyncHandlerController.getService();
        InjectedValue injectedHandler = new InjectedValue();
        injectedHandler.inject(handlerToAssignController.getValue());
        service.addHandler((InjectedValue<Handler>)injectedHandler);
    }
}

