/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.deployment.processors;

import java.lang.reflect.Constructor;
import java.util.List;
import javax.enterprise.inject.spi.Extension;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.PrivateSubDeploymentMarker;
import org.jboss.as.server.deployment.ServicesAttachment;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.as.weld.WeldDeploymentMarker;
import org.jboss.as.weld.deployment.WeldAttachments;
import org.jboss.as.weld.deployment.processors.SecurityActions;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.weld.metadata.MetadataImpl;

public class WeldPortableExtensionProcessor
implements DeploymentUnitProcessor {
    private static final Logger log = Logger.getLogger((String)"org.jboss.weld");
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (PrivateSubDeploymentMarker.isPrivate((DeploymentUnit)deploymentUnit) ? !WeldDeploymentMarker.isPartOfWeldDeployment(deploymentUnit) : (deploymentUnit.getParent() == null ? !WeldDeploymentMarker.isPartOfWeldDeployment(deploymentUnit) : !WeldDeploymentMarker.isPartOfWeldDeployment(deploymentUnit.getParent()))) {
            return;
        }
        DeploymentUnit topLevelDeployment = deploymentUnit.getParent() == null ? deploymentUnit : deploymentUnit.getParent();
        ServicesAttachment services = (ServicesAttachment)deploymentUnit.getAttachment(Attachments.SERVICES);
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        ClassLoader oldCl = SecurityActions.getContextClassLoader();
        try {
            SecurityActions.setContextClassLoader((ClassLoader)module.getClassLoader());
            this.loadAttachments(services, module, topLevelDeployment);
        }
        finally {
            SecurityActions.setContextClassLoader(oldCl);
        }
    }

    private void loadAttachments(ServicesAttachment servicesAttachment, Module module, DeploymentUnit deploymentUnit) {
        DeploymentReflectionIndex index = (DeploymentReflectionIndex)deploymentUnit.getAttachment(Attachments.REFLECTION_INDEX);
        List services = servicesAttachment.getServiceImplementations(Extension.class.getName());
        if (services == null) {
            return;
        }
        for (String service : services) {
            Extension extension = this.loadExtension(service, index, (ClassLoader)module.getClassLoader());
            if (extension == null) continue;
            MetadataImpl metadata = new MetadataImpl((Object)extension, deploymentUnit.getName());
            log.debug((Object)("Loaded portable extension " + extension));
            deploymentUnit.addToAttachmentList(WeldAttachments.PORTABLE_EXTENSIONS, (Object)metadata);
        }
    }

    private Extension loadExtension(String serviceClassName, DeploymentReflectionIndex index, ClassLoader loader) {
        Class<?> clazz = null;
        Class<?> serviceClass = null;
        try {
            serviceClass = clazz = loader.loadClass(serviceClassName);
            Constructor ctor = index.getClassIndex(serviceClass).getConstructor(EMPTY_STRING_ARRAY);
            return (Extension)ctor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)("Could not load portable extension class " + serviceClassName));
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Service class " + serviceClassName + " didn't implement the Extension interface");
        }
        catch (Exception e) {
            log.warn((Object)("Could not load portable extension " + serviceClassName), (Throwable)e);
        }
        return null;
    }

    public void undeploy(DeploymentUnit context) {
    }
}

