/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.metatype.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.felix.metatype.AD;
import org.apache.felix.metatype.OCD;
import org.apache.felix.metatype.internal.LocalizedAttributeDefinition;
import org.apache.felix.metatype.internal.LocalizedBase;
import org.apache.felix.metatype.internal.l10n.Resources;
import org.osgi.framework.Bundle;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;

public class LocalizedObjectClassDefinition
extends LocalizedBase
implements ObjectClassDefinition {
    private Bundle bundle;
    private OCD ocd;

    public LocalizedObjectClassDefinition(Bundle bundle, OCD ocd, Resources resources) {
        super(resources);
        this.bundle = bundle;
        this.ocd = ocd;
    }

    public AttributeDefinition[] getAttributeDefinitions(int filter) {
        if (this.ocd.getAttributeDefinitions() == null) {
            return null;
        }
        RequiredFilterIterator adhIter = this.ocd.getAttributeDefinitions().values().iterator();
        if (filter == 2 || filter == 1) {
            boolean required = filter == 1;
            adhIter = new RequiredFilterIterator(adhIter, required);
        } else if (filter != -1) {
            return null;
        }
        if (!adhIter.hasNext()) {
            return null;
        }
        ArrayList<LocalizedAttributeDefinition> result = new ArrayList<LocalizedAttributeDefinition>();
        while (adhIter.hasNext()) {
            result.add(new LocalizedAttributeDefinition((AD)adhIter.next(), this.getResources()));
        }
        return result.toArray(new AttributeDefinition[result.size()]);
    }

    public String getDescription() {
        return this.localize(this.ocd.getDescription());
    }

    public InputStream getIcon(int size) throws IOException {
        Map icons = this.ocd.getIcons();
        if (icons == null) {
            return null;
        }
        String iconPath = (String)icons.get(new Integer(size));
        if (iconPath == null) {
            Integer selected = new Integer(Integer.MIN_VALUE);
            Iterator ei = icons.keySet().iterator();
            while (ei.hasNext()) {
                Map.Entry entry = (Map.Entry)ei.next();
                Integer keySize = (Integer)entry.getKey();
                if (keySize > size || selected.compareTo(keySize) >= 0) continue;
                selected = keySize;
            }
            iconPath = (String)icons.get(selected);
        }
        if (iconPath == null) {
            return null;
        }
        URL url = this.bundle.getEntry(iconPath = this.localize(iconPath));
        if (url == null) {
            return null;
        }
        return url.openStream();
    }

    public String getID() {
        return this.ocd.getID();
    }

    public String getName() {
        return this.localize(this.ocd.getName());
    }

    private static class RequiredFilterIterator
    implements Iterator {
        private final Iterator base;
        private final boolean required;
        private AD next;

        private RequiredFilterIterator(Iterator base, boolean required) {
            this.base = base;
            this.required = required;
            this.next = this.seek();
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            AD toReturn = this.next;
            this.next = this.seek();
            return toReturn;
        }

        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        private AD seek() {
            if (this.base.hasNext()) {
                AD next;
                while ((next = (AD)this.base.next()).isRequired() != this.required && this.base.hasNext()) {
                }
                if (next.isRequired() == this.required) {
                    return next;
                }
            }
            return null;
        }
    }
}

