/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.xts;

import org.jboss.as.xts.SecurityActions;
import org.jboss.jbossts.XTSService;
import org.jboss.jbossts.xts.environment.WSCEnvironmentBean;
import org.jboss.jbossts.xts.environment.XTSPropertyManager;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class XTSManagerService
extends AbstractService<XTSService> {
    private final String coordinatorURL;
    private volatile XTSService xtsService;

    public XTSManagerService(String coordinatorURL) {
        this.coordinatorURL = coordinatorURL;
        this.xtsService = null;
    }

    public XTSService getValue() throws IllegalStateException {
        return this.xtsService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(StartContext context) throws StartException {
        ClassLoader loader = XTSService.class.getClassLoader();
        SecurityActions.setContextLoader(loader);
        try {
            if (this.coordinatorURL != null) {
                WSCEnvironmentBean wscEnVBean = XTSPropertyManager.getWSCEnvironmentBean();
                wscEnVBean.setCoordinatorURL11(this.coordinatorURL);
            }
            XTSService service = new XTSService();
            try {
                service.start();
            }
            catch (Exception e) {
                throw new StartException("XTS service start failed", (Throwable)e);
            }
            this.xtsService = service;
        }
        finally {
            SecurityActions.setContextLoader(null);
        }
    }

    public synchronized void stop(StopContext context) {
        if (this.xtsService != null) {
            try {
                this.xtsService.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

