/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.EncodingToCharset;
import org.jboss.logging.Logger;

public class B2CConverter {
    protected static Logger log = Logger.getLogger(B2CConverter.class);
    protected CharsetDecoder decoder = null;
    protected ByteBuffer bb = null;
    protected CharBuffer cb = null;
    protected ByteBuffer leftovers = null;

    public B2CConverter(String charset) throws IOException {
        try {
            this.decoder = EncodingToCharset.toCharset(charset).newDecoder();
        }
        catch (UnsupportedCharsetException e) {
            throw new UnsupportedEncodingException(charset);
        }
        byte[] left = new byte[4];
        this.leftovers = ByteBuffer.wrap(left);
    }

    public void recycle() {
        this.decoder.reset();
        this.leftovers.position(0);
    }

    public void convert(ByteChunk bc, CharChunk cc) throws IOException {
        if (this.bb == null || this.bb.array() != bc.getBuffer()) {
            this.bb = ByteBuffer.wrap(bc.getBuffer(), bc.getStart(), bc.getLength());
        } else {
            this.bb.limit(bc.getEnd());
            this.bb.position(bc.getStart());
        }
        if (this.cb == null || this.cb.array() != cc.getBuffer()) {
            this.cb = CharBuffer.wrap(cc.getBuffer(), cc.getEnd(), cc.getBuffer().length - cc.getEnd());
        } else {
            this.cb.limit(cc.getBuffer().length);
            this.cb.position(cc.getEnd());
        }
        CoderResult result = null;
        if (this.leftovers.position() > 0) {
            int pos = this.cb.position();
            do {
                this.leftovers.put(bc.substractB());
                this.leftovers.flip();
                result = this.decoder.decode(this.leftovers, this.cb, false);
                this.leftovers.position(this.leftovers.limit());
                this.leftovers.limit(this.leftovers.array().length);
            } while (result.isUnderflow() && this.cb.position() == pos);
            if (result.isError() || result.isMalformed()) {
                result.throwException();
            }
            this.bb.position(bc.getStart());
            this.leftovers.position(0);
        }
        if ((result = this.decoder.decode(this.bb, this.cb, false)).isError() || result.isMalformed()) {
            result.throwException();
        } else if (result.isOverflow()) {
            bc.setOffset(this.bb.position());
            cc.setEnd(this.cb.position());
        } else if (result.isUnderflow()) {
            bc.setOffset(this.bb.position());
            cc.setEnd(this.cb.position());
            if (bc.getLength() > 0) {
                this.leftovers.limit(this.leftovers.array().length);
                this.leftovers.position(bc.getLength());
                bc.substract(this.leftovers.array(), 0, bc.getLength());
            }
        }
    }
}

