/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.tomcat.util.res.StringManager;
import org.jboss.logging.Logger;

public class JreMemoryLeakPreventionListener
implements LifecycleListener {
    private static Logger log = Logger.getLogger(JreMemoryLeakPreventionListener.class);
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    protected boolean appContextProtection = true;
    protected boolean urlCacheProtection = true;
    protected boolean xmlParsingProtection = true;

    public boolean isAppContextProtection() {
        return this.appContextProtection;
    }

    public void setAppContextProtection(boolean appContextProtection) {
        this.appContextProtection = appContextProtection;
    }

    public boolean isUrlCacheProtection() {
        return this.urlCacheProtection;
    }

    public void setUrlCacheProtection(boolean urlCacheProtection) {
        this.urlCacheProtection = urlCacheProtection;
    }

    public boolean isXmlParsingProtection() {
        return this.xmlParsingProtection;
    }

    public void setXmlParsingProtection(boolean xmlParsingProtection) {
        this.xmlParsingProtection = xmlParsingProtection;
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if ("init".equals(event.getType())) {
            if (this.appContextProtection) {
                ImageIO.getCacheDirectory();
            }
            if (this.urlCacheProtection) {
                try {
                    URL url = new URL("jar:file://dummy.jar!/");
                    URLConnection uConn = url.openConnection();
                    uConn.setDefaultUseCaches(false);
                }
                catch (MalformedURLException e) {
                    log.error((Object)sm.getString("jreLeakListener.jarUrlConnCacheFail"), (Throwable)e);
                }
                catch (IOException e) {
                    log.error((Object)sm.getString("jreLeakListener.jarUrlConnCacheFail"), (Throwable)e);
                }
            }
            if (this.xmlParsingProtection) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                try {
                    factory.newDocumentBuilder();
                }
                catch (ParserConfigurationException e) {
                    log.error((Object)sm.getString("jreLeakListener.xmlParseFail"), (Throwable)e);
                }
            }
        }
    }
}

