/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.vfs.VirtualFile;

public class ModuleIdentifierProcessor
implements DeploymentUnitProcessor {
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ModuleIdentifier moduleIdentifier;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ResourceRoot deploymentRoot = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        DeploymentUnit parent = deploymentUnit.getParent();
        DeploymentUnit topLevelDeployment = parent == null ? deploymentUnit : parent;
        VirtualFile toplevelRoot = topLevelDeployment.getAttachment(Attachments.DEPLOYMENT_ROOT).getRoot();
        if (deploymentUnit.getParent() == null) {
            moduleIdentifier = ModuleIdentifier.create((String)("deployment." + deploymentUnit.getName()));
        } else {
            String relativePath = deploymentRoot.getRoot().getPathNameRelativeTo(toplevelRoot);
            moduleIdentifier = ModuleIdentifier.create((String)("deployment." + topLevelDeployment.getName() + '.' + relativePath.replace('/', '.')));
        }
        deploymentUnit.putAttachment(Attachments.MODULE_IDENTIFIER, moduleIdentifier);
    }

    @Override
    public void undeploy(DeploymentUnit deploymentUnit) {
    }
}

