/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.server.deployment.AttachmentList;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.module.ResourceRoot;

public final class DeploymentUtils {
    public static List<ResourceRoot> allResourceRoots(DeploymentUnit deploymentUnit) {
        AttachmentList<ResourceRoot> resourceRoots;
        ArrayList<ResourceRoot> roots = new ArrayList<ResourceRoot>();
        ResourceRoot deploymentRoot = deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        if (deploymentRoot != null) {
            roots.add(deploymentRoot);
        }
        if ((resourceRoots = deploymentUnit.getAttachment(Attachments.RESOURCE_ROOTS)) != null) {
            roots.addAll(resourceRoots);
        }
        return roots;
    }

    public static DeploymentUnit getTopDeploymentUnit(DeploymentUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Null initial unit");
        }
        DeploymentUnit parent = unit.getParent();
        while (parent != null) {
            unit = parent;
            parent = unit.getParent();
        }
        return unit;
    }

    private DeploymentUtils() {
    }
}

