/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.File;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.parsing.StandaloneXml;
import org.jboss.as.controller.persistence.AbstractConfigurationPersister;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerTask;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.threads.AsyncFuture;

public final class ServerStartTask
implements ServerTask,
Serializable,
ObjectInputValidation {
    private static final long serialVersionUID = -8505496119636153918L;
    private final String serverName;
    private final int portOffset;
    private final List<ServiceActivator> startServices;
    private final List<ModelNode> updates;
    private final ServerEnvironment providedEnvironment;

    public ServerStartTask(String serverName, int portOffset, List<ServiceActivator> startServices, List<ModelNode> updates) {
        if (serverName == null || serverName.length() == 0) {
            throw new IllegalArgumentException("Server name " + serverName + " is invalid; cannot be null or blank");
        }
        this.serverName = serverName;
        this.portOffset = portOffset;
        this.startServices = startServices;
        this.updates = updates;
        Properties properties = new Properties(System.getProperties());
        properties.setProperty("jboss.server.name", serverName);
        properties.setProperty("jboss.server.deploy.dir", properties.getProperty("jboss.domain.deployment.dir"));
        properties.setProperty("jboss.server.base.dir", properties.getProperty("jboss.domain.servers.dir") + File.separatorChar + serverName);
        this.providedEnvironment = new ServerEnvironment(properties, System.getenv(), null, ServerEnvironment.LaunchType.DOMAIN);
    }

    @Override
    public AsyncFuture<ServiceContainer> run(List<ServiceActivator> runServices) {
        Bootstrap bootstrap = Bootstrap.Factory.newInstance();
        Bootstrap.Configuration configuration = new Bootstrap.Configuration();
        configuration.setServerEnvironment(this.providedEnvironment);
        configuration.setConfigurationPersister((ExtensibleConfigurationPersister)new AbstractConfigurationPersister((XMLElementWriter)new StandaloneXml(configuration.getModuleLoader())){
            private final ConfigurationPersister.PersistenceResource pr;
            {
                this.pr = new ConfigurationPersister.PersistenceResource(){

                    public void commit() {
                    }

                    public void rollback() {
                    }
                };
            }

            public ConfigurationPersister.PersistenceResource store(ModelNode model, Set<PathAddress> affectedAddresses) throws ConfigurationPersistenceException {
                return this.pr;
            }

            public List<ModelNode> load() throws ConfigurationPersistenceException {
                return ServerStartTask.this.updates;
            }
        });
        return bootstrap.bootstrap(configuration, this.startServices);
    }

    @Override
    public void validateObject() throws InvalidObjectException {
        if (this.serverName == null) {
            throw new InvalidObjectException("serverName is null");
        }
        if (this.portOffset < 0) {
            throw new InvalidObjectException("portOffset is out of range");
        }
        if (this.updates == null) {
            throw new InvalidObjectException("updates is null");
        }
        if (this.startServices == null) {
            throw new InvalidObjectException("startServices is null");
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        ois.registerValidation(this, 100);
    }
}

