/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.as.controller.AbstractControllerService;
import org.jboss.as.controller.BootContext;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.BootstrapListener;
import org.jboss.as.server.DeployerChainAddHandler;
import org.jboss.as.server.ServerControllerModelUtil;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.Services;
import org.jboss.as.server.controller.descriptions.ServerDescriptionProviders;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.ServiceLoaderProcessor;
import org.jboss.as.server.deployment.SubDeploymentProcessor;
import org.jboss.as.server.deployment.annotation.AnnotationIndexProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndexProcessor;
import org.jboss.as.server.deployment.integration.Seam2Processor;
import org.jboss.as.server.deployment.module.AdditionalModuleProcessor;
import org.jboss.as.server.deployment.module.ClassFileTransformerProcessor;
import org.jboss.as.server.deployment.module.DeploymentRootMountProcessor;
import org.jboss.as.server.deployment.module.DeploymentStructureDescriptorParser;
import org.jboss.as.server.deployment.module.ManifestAttachmentProcessor;
import org.jboss.as.server.deployment.module.ManifestClassPathProcessor;
import org.jboss.as.server.deployment.module.ManifestDependencyProcessor;
import org.jboss.as.server.deployment.module.ManifestExtensionListProcessor;
import org.jboss.as.server.deployment.module.ManifestExtensionNameProcessor;
import org.jboss.as.server.deployment.module.ModuleClassPathProcessor;
import org.jboss.as.server.deployment.module.ModuleDependencyProcessor;
import org.jboss.as.server.deployment.module.ModuleExtensionListProcessor;
import org.jboss.as.server.deployment.module.ModuleExtensionNameProcessor;
import org.jboss.as.server.deployment.module.ModuleIdentifierProcessor;
import org.jboss.as.server.deployment.module.ModuleInformationServiceProcessor;
import org.jboss.as.server.deployment.module.ModuleSpecProcessor;
import org.jboss.as.server.deployment.module.ServerDependenciesProcessor;
import org.jboss.as.server.deployment.module.SubDeploymentDependencyProcessor;
import org.jboss.as.server.deployment.reflect.InstallReflectionIndexProcessor;
import org.jboss.as.server.deployment.repository.api.ContentRepository;
import org.jboss.as.server.deployment.repository.api.ServerDeploymentRepository;
import org.jboss.as.server.deployment.service.ServiceActivatorDependencyProcessor;
import org.jboss.as.server.deployment.service.ServiceActivatorProcessor;
import org.jboss.as.server.moduleservice.ExtensionIndexService;
import org.jboss.as.server.moduleservice.ExternalModuleService;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public final class ServerService
extends AbstractControllerService {
    private final InjectedValue<ServerDeploymentRepository> injectedDeploymentRepository = new InjectedValue();
    private final InjectedValue<ContentRepository> injectedContentRepository = new InjectedValue();
    private final InjectedValue<ServiceModuleLoader> injectedModuleLoader = new InjectedValue();
    private final InjectedValue<ExternalModuleService> injectedExternalModuleService = new InjectedValue();
    private final Bootstrap.Configuration configuration;
    private final BootstrapListener bootstrapListener;
    private final ControlledProcessState processState;

    ServerService(Bootstrap.Configuration configuration, ControlledProcessState processState, OperationStepHandler prepareStep, BootstrapListener bootstrapListener) {
        super(OperationContext.Type.SERVER, (ConfigurationPersister)configuration.getConfigurationPersister(), processState, ServerDescriptionProviders.ROOT_PROVIDER, prepareStep);
        this.configuration = configuration;
        this.bootstrapListener = bootstrapListener;
        this.processState = processState;
    }

    public static void addService(ServiceTarget serviceTarget, Bootstrap.Configuration configuration, ControlledProcessState processState, BootstrapListener bootstrapListener) {
        ServerService service = new ServerService(configuration, processState, null, bootstrapListener);
        ServiceBuilder serviceBuilder = serviceTarget.addService(Services.JBOSS_SERVER_CONTROLLER, (Service)service);
        serviceBuilder.addDependency(ServerDeploymentRepository.SERVICE_NAME, ServerDeploymentRepository.class, service.injectedDeploymentRepository);
        serviceBuilder.addDependency(ContentRepository.SERVICE_NAME, ContentRepository.class, service.injectedContentRepository);
        serviceBuilder.addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ServiceModuleLoader.class, service.injectedModuleLoader);
        serviceBuilder.addDependency(Services.JBOSS_EXTERNAL_MODULE_SERVICE, ExternalModuleService.class, service.injectedExternalModuleService);
        serviceBuilder.install();
    }

    public void start(StartContext context) throws StartException {
        super.start(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void boot(BootContext context) throws ConfigurationPersistenceException {
        ServerEnvironment serverEnvironment = this.configuration.getServerEnvironment();
        ServiceTarget serviceTarget = context.getServiceTarget();
        serviceTarget.addListener(ServiceListener.Inheritance.ALL, (ServiceListener)this.bootstrapListener);
        File[] extDirs = serverEnvironment.getJavaExtDirs();
        File[] newExtDirs = Arrays.copyOf(extDirs, extDirs.length + 1);
        newExtDirs[extDirs.length] = new File(serverEnvironment.getServerBaseDir(), "lib/ext");
        serviceTarget.addService(org.jboss.as.server.deployment.Services.JBOSS_DEPLOYMENT_EXTENSION_INDEX, (Service)new ExtensionIndexService(newExtDirs)).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        DeployerChainAddHandler.addDeploymentProcessor(Phase.STRUCTURE, 2560, new DeploymentUnitProcessor(){

            @Override
            public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
                phaseContext.getDeploymentUnit().putAttachment(Attachments.SERVICE_MODULE_LOADER, ServerService.this.injectedModuleLoader.getValue());
                phaseContext.getDeploymentUnit().putAttachment(Attachments.EXTERNAL_MODULE_SERVICE, ServerService.this.injectedExternalModuleService.getValue());
            }

            @Override
            public void undeploy(DeploymentUnit context) {
                context.removeAttachment(Attachments.SERVICE_MODULE_LOADER);
            }
        });
        DeployerChainAddHandler.addDeploymentProcessor(Phase.STRUCTURE, 1, new DeploymentRootMountProcessor());
        DeployerChainAddHandler.addDeploymentProcessor(Phase.STRUCTURE, 256, new ManifestAttachmentProcessor());
        DeployerChainAddHandler.addDeploymentProcessor(Phase.STRUCTURE, 3584, new ManifestAttachmentProcessor());
        DeployerChainAddHandler.addDeploymentProcessor(Phase.STRUCTURE, 3840, new SubDeploymentProcessor());
        DeployerChainAddHandler.addDeploymentProcessor(Phase.STRUCTURE, 4096, new ModuleIdentifierProcessor());
        DeployerChainAddHandler.addDeploymentProcessor(Phase.STRUCTURE, 2816, new AnnotationIndexProcessor());
        DeployerChainAddHandler.addDeploymentProcessor(Phase.PARSE, 513, new DeploymentStructureDescriptorParser());
        DeployerChainAddHandler.addDeploymentProcessor(Phase.PARSE, 768, new ManifestDependencyProcessor());
        DeployerChainAddHandler.addDeploymentProcessor(Phase.PARSE, 769, new CompositeIndexProcessor());
        DeployerChainAddHandler.addDeploymentProcessor(Phase.PARSE, 1280, new AdditionalModuleProcessor());
        DeployerChainAddHandler.addDeploymentProcessor(Phase.PARSE, 1536, new ManifestClassPathProcessor());
        DeployerChainAddHandler.addDeploymentProcessor(Phase.PARSE, 1792, new ManifestExtensionListProcessor());
        DeployerChainAddHandler.addDeploymentProcessor(Phase.PARSE, 2048, new ManifestExtensionNameProcessor());
        DeployerChainAddHandler.addDeploymentProcessor(Phase.PARSE, 8704, new ServiceLoaderProcessor());
        DeployerChainAddHandler.addDeploymentProcessor(Phase.DEPENDENCIES, 256, new ModuleDependencyProcessor());
        DeployerChainAddHandler.addDeploymentProcessor(Phase.DEPENDENCIES, 1280, new ServiceActivatorDependencyProcessor());
        DeployerChainAddHandler.addDeploymentProcessor(Phase.DEPENDENCIES, 2048, new ModuleClassPathProcessor());
        DeployerChainAddHandler.addDeploymentProcessor(Phase.DEPENDENCIES, 2304, new ModuleExtensionListProcessor());
        DeployerChainAddHandler.addDeploymentProcessor(Phase.DEPENDENCIES, 3584, new SubDeploymentDependencyProcessor());
        DeployerChainAddHandler.addDeploymentProcessor(Phase.DEPENDENCIES, 4608, new ServerDependenciesProcessor());
        DeployerChainAddHandler.addDeploymentProcessor(Phase.DEPENDENCIES, 4864, new ModuleInformationServiceProcessor());
        DeployerChainAddHandler.addDeploymentProcessor(Phase.CONFIGURE_MODULE, 256, new ModuleSpecProcessor());
        DeployerChainAddHandler.addDeploymentProcessor(Phase.POST_MODULE, 2560, new ModuleExtensionNameProcessor());
        DeployerChainAddHandler.addDeploymentProcessor(Phase.POST_MODULE, 512, new InstallReflectionIndexProcessor());
        DeployerChainAddHandler.addDeploymentProcessor(Phase.POST_MODULE, 513, new ClassFileTransformerProcessor());
        DeployerChainAddHandler.addDeploymentProcessor(Phase.INSTALL, 1280, new ServiceActivatorProcessor());
        DeployerChainAddHandler.addDeploymentProcessor(Phase.DEPENDENCIES, 2561, new Seam2Processor(serviceTarget));
        try {
            super.boot(context);
        }
        finally {
            DeployerChainAddHandler.DEPLOYERS.set(null);
        }
        this.bootstrapListener.tick();
    }

    protected void boot(List<ModelNode> bootOperations) throws ConfigurationPersistenceException {
        ArrayList<ModelNode> operations = new ArrayList<ModelNode>(bootOperations);
        operations.add(DeployerChainAddHandler.OPERATION);
        super.boot(operations);
    }

    public void stop(StopContext context) {
        super.stop(context);
    }

    protected void initModel(Resource rootResource, ManagementResourceRegistration rootRegistration) {
        ServerControllerModelUtil.updateCoreModel(rootResource.getModel());
        ServerControllerModelUtil.initOperations(rootRegistration, (ContentRepository)this.injectedContentRepository.getValue(), this.configuration.getConfigurationPersister(), this.configuration.getServerEnvironment(), this.processState);
        rootResource.registerChild(PathElement.pathElement((String)"core-service", (String)"management"), Resource.Factory.create());
        rootResource.registerChild(PathElement.pathElement((String)"core-service", (String)"service-container"), Resource.Factory.create());
    }
}

