/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.engine.jdbc.spi.SqlExceptionHelper;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.spi.Stoppable;
import org.hibernate.tool.hbm2ddl.ConnectionHelper;

class ManagedProviderConnectionHelper
implements ConnectionHelper {
    private Properties cfgProperties;
    private ConnectionProvider connectionProvider;
    private Connection connection;

    public ManagedProviderConnectionHelper(Properties cfgProperties) {
        this.cfgProperties = cfgProperties;
    }

    @Override
    public void prepare(boolean needsAutoCommit) throws SQLException {
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() throws SQLException {
        if (this.connection != null) {
            try {
                new SqlExceptionHelper().logAndClearWarnings(this.connection);
                this.connectionProvider.closeConnection(this.connection);
            }
            finally {
                if (this.connectionProvider instanceof Stoppable) {
                    ((Stoppable)((Object)this.connectionProvider)).stop();
                }
                this.connectionProvider = null;
            }
        }
        this.connection = null;
    }
}

