/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.binding.CustomSQL;
import org.hibernate.metamodel.source.LocalBindingContext;
import org.hibernate.metamodel.source.Origin;
import org.hibernate.metamodel.source.binder.AttributeSource;
import org.hibernate.metamodel.source.binder.AttributeSourceContainer;
import org.hibernate.metamodel.source.binder.ConstraintSource;
import org.hibernate.metamodel.source.binder.EntitySource;
import org.hibernate.metamodel.source.binder.MetaAttributeSource;
import org.hibernate.metamodel.source.binder.SubclassEntitySource;
import org.hibernate.metamodel.source.binder.TableSource;
import org.hibernate.metamodel.source.hbm.BagAttributeSourceImpl;
import org.hibernate.metamodel.source.hbm.ComponentAttributeSourceImpl;
import org.hibernate.metamodel.source.hbm.EntityHierarchyImpl;
import org.hibernate.metamodel.source.hbm.Helper;
import org.hibernate.metamodel.source.hbm.ManyToOneAttributeSourceImpl;
import org.hibernate.metamodel.source.hbm.MappingDocument;
import org.hibernate.metamodel.source.hbm.PropertyAttributeSourceImpl;
import org.hibernate.metamodel.source.hbm.SetAttributeSourceImpl;
import org.hibernate.metamodel.source.hbm.SubclassEntitySourceImpl;
import org.hibernate.metamodel.source.hbm.jaxb.mapping.EntityElement;
import org.hibernate.metamodel.source.hbm.jaxb.mapping.XMLAnyElement;
import org.hibernate.metamodel.source.hbm.jaxb.mapping.XMLBagElement;
import org.hibernate.metamodel.source.hbm.jaxb.mapping.XMLComponentElement;
import org.hibernate.metamodel.source.hbm.jaxb.mapping.XMLIdbagElement;
import org.hibernate.metamodel.source.hbm.jaxb.mapping.XMLListElement;
import org.hibernate.metamodel.source.hbm.jaxb.mapping.XMLManyToOneElement;
import org.hibernate.metamodel.source.hbm.jaxb.mapping.XMLMapElement;
import org.hibernate.metamodel.source.hbm.jaxb.mapping.XMLOneToOneElement;
import org.hibernate.metamodel.source.hbm.jaxb.mapping.XMLPropertyElement;
import org.hibernate.metamodel.source.hbm.jaxb.mapping.XMLSetElement;
import org.hibernate.metamodel.source.hbm.jaxb.mapping.XMLSynchronizeElement;
import org.hibernate.metamodel.source.hbm.jaxb.mapping.XMLTuplizerElement;

public abstract class AbstractEntitySourceImpl
implements EntitySource {
    private final MappingDocument sourceMappingDocument;
    private final EntityElement entityElement;
    private List<SubclassEntitySource> subclassEntitySources = new ArrayList<SubclassEntitySource>();
    private EntityHierarchyImpl entityHierarchy;

    protected AbstractEntitySourceImpl(MappingDocument sourceMappingDocument, EntityElement entityElement) {
        this.sourceMappingDocument = sourceMappingDocument;
        this.entityElement = entityElement;
    }

    protected EntityElement entityElement() {
        return this.entityElement;
    }

    protected MappingDocument sourceMappingDocument() {
        return this.sourceMappingDocument;
    }

    @Override
    public Origin getOrigin() {
        return this.sourceMappingDocument.getOrigin();
    }

    @Override
    public LocalBindingContext getLocalBindingContext() {
        return this.sourceMappingDocument.getMappingLocalBindingContext();
    }

    @Override
    public String getEntityName() {
        return StringHelper.isNotEmpty(this.entityElement.getEntityName()) ? this.entityElement.getEntityName() : this.getClassName();
    }

    @Override
    public String getClassName() {
        return this.getLocalBindingContext().qualifyClassName(this.entityElement.getName());
    }

    @Override
    public String getJpaEntityName() {
        return null;
    }

    @Override
    public boolean isAbstract() {
        return Helper.getBooleanValue(this.entityElement.isAbstract(), false);
    }

    @Override
    public boolean isLazy() {
        return Helper.getBooleanValue(this.entityElement.isAbstract(), true);
    }

    @Override
    public String getProxy() {
        return this.entityElement.getProxy();
    }

    @Override
    public int getBatchSize() {
        return Helper.getIntValue(this.entityElement.getBatchSize(), -1);
    }

    @Override
    public boolean isDynamicInsert() {
        return this.entityElement.isDynamicInsert();
    }

    @Override
    public boolean isDynamicUpdate() {
        return this.entityElement.isDynamicUpdate();
    }

    @Override
    public boolean isSelectBeforeUpdate() {
        return this.entityElement.isSelectBeforeUpdate();
    }

    protected EntityMode determineEntityMode() {
        return StringHelper.isNotEmpty(this.getClassName()) ? EntityMode.POJO : EntityMode.MAP;
    }

    @Override
    public String getCustomTuplizerClassName() {
        if (this.entityElement.getTuplizer() == null) {
            return null;
        }
        EntityMode entityMode = this.determineEntityMode();
        for (XMLTuplizerElement tuplizerElement : this.entityElement.getTuplizer()) {
            if (entityMode != EntityMode.parse(tuplizerElement.getEntityMode())) continue;
            return tuplizerElement.getClazz();
        }
        return null;
    }

    @Override
    public String getCustomPersisterClassName() {
        return this.getLocalBindingContext().qualifyClassName(this.entityElement.getPersister());
    }

    @Override
    public String getCustomLoaderName() {
        return this.entityElement.getLoader() != null ? this.entityElement.getLoader().getQueryRef() : null;
    }

    @Override
    public CustomSQL getCustomSqlInsert() {
        return Helper.buildCustomSql(this.entityElement.getSqlInsert());
    }

    @Override
    public CustomSQL getCustomSqlUpdate() {
        return Helper.buildCustomSql(this.entityElement.getSqlUpdate());
    }

    @Override
    public CustomSQL getCustomSqlDelete() {
        return Helper.buildCustomSql(this.entityElement.getSqlDelete());
    }

    @Override
    public List<String> getSynchronizedTableNames() {
        ArrayList<String> tableNames = new ArrayList<String>();
        for (XMLSynchronizeElement synchronizeElement : this.entityElement.getSynchronize()) {
            tableNames.add(synchronizeElement.getTable());
        }
        return tableNames;
    }

    @Override
    public Iterable<MetaAttributeSource> metaAttributes() {
        return Helper.buildMetaAttributeSources(this.entityElement.getMeta());
    }

    @Override
    public String getPath() {
        return this.sourceMappingDocument.getMappingLocalBindingContext().determineEntityName(this.entityElement);
    }

    @Override
    public Iterable<AttributeSource> attributeSources() {
        ArrayList<AttributeSource> attributeSources = new ArrayList<AttributeSource>();
        for (Object attributeElement : this.entityElement.getPropertyOrManyToOneOrOneToOne()) {
            if (XMLPropertyElement.class.isInstance(attributeElement)) {
                attributeSources.add(new PropertyAttributeSourceImpl((XMLPropertyElement)XMLPropertyElement.class.cast(attributeElement), this.sourceMappingDocument().getMappingLocalBindingContext()));
                continue;
            }
            if (XMLComponentElement.class.isInstance(attributeElement)) {
                attributeSources.add(new ComponentAttributeSourceImpl((XMLComponentElement)attributeElement, this, this.sourceMappingDocument.getMappingLocalBindingContext()));
                continue;
            }
            if (XMLManyToOneElement.class.isInstance(attributeElement)) {
                attributeSources.add(new ManyToOneAttributeSourceImpl((XMLManyToOneElement)XMLManyToOneElement.class.cast(attributeElement), this.sourceMappingDocument().getMappingLocalBindingContext()));
                continue;
            }
            if (XMLOneToOneElement.class.isInstance(attributeElement) || XMLAnyElement.class.isInstance(attributeElement)) continue;
            if (XMLBagElement.class.isInstance(attributeElement)) {
                attributeSources.add(new BagAttributeSourceImpl((XMLBagElement)XMLBagElement.class.cast(attributeElement), (AttributeSourceContainer)this));
                continue;
            }
            if (XMLIdbagElement.class.isInstance(attributeElement)) continue;
            if (XMLSetElement.class.isInstance(attributeElement)) {
                attributeSources.add(new SetAttributeSourceImpl((XMLSetElement)XMLSetElement.class.cast(attributeElement), (AttributeSourceContainer)this));
                continue;
            }
            if (XMLListElement.class.isInstance(attributeElement) || XMLMapElement.class.isInstance(attributeElement)) continue;
            throw new AssertionFailure("Unexpected attribute element type encountered : " + attributeElement.getClass());
        }
        return attributeSources;
    }

    public void injectHierarchy(EntityHierarchyImpl entityHierarchy) {
        this.entityHierarchy = entityHierarchy;
    }

    @Override
    public void add(SubclassEntitySource subclassEntitySource) {
        this.add((SubclassEntitySourceImpl)subclassEntitySource);
    }

    public void add(SubclassEntitySourceImpl subclassEntitySource) {
        this.entityHierarchy.processSubclass(subclassEntitySource);
        this.subclassEntitySources.add(subclassEntitySource);
    }

    @Override
    public Iterable<SubclassEntitySource> subclassEntitySources() {
        return this.subclassEntitySources;
    }

    @Override
    public String getDiscriminatorMatchValue() {
        return null;
    }

    @Override
    public Iterable<ConstraintSource> getConstraints() {
        return Collections.emptySet();
    }

    @Override
    public Iterable<TableSource> getSecondaryTables() {
        return Collections.emptySet();
    }
}

