/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.xml.mocker;

import java.beans.Introspector;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.CascadeType;
import org.hibernate.HibernateException;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.source.annotation.jaxb.XMLCascadeType;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class MockHelper {
    static final AnnotationValue[] EMPTY_ANNOTATION_VALUE_ARRAY = new AnnotationValue[0];
    static final Type[] EMPTY_TYPE_ARRAY = new Type[0];

    static void stringArrayValue(String name, List<String> values, List<AnnotationValue> annotationValueList) {
        if (MockHelper.isNotEmpty(values)) {
            AnnotationValue[] annotationValues = new AnnotationValue[values.size()];
            for (int j = 0; j < values.size(); ++j) {
                annotationValues[j] = MockHelper.stringValue("", values.get(j));
            }
            annotationValueList.add(AnnotationValue.createArrayValue((String)name, (AnnotationValue[])annotationValues));
        }
    }

    static AnnotationValue[] stringValueArray(String name, String value) {
        return MockHelper.nullSafe(MockHelper.stringValue(name, value));
    }

    private static AnnotationValue stringValue(String name, String value) {
        if (StringHelper.isNotEmpty(value)) {
            return AnnotationValue.createStringValue((String)name, (String)value);
        }
        return null;
    }

    static void stringValue(String name, String value, List<AnnotationValue> annotationValueList) {
        MockHelper.addToCollectionIfNotNull(annotationValueList, MockHelper.stringValue(name, value));
    }

    private static AnnotationValue integerValue(String name, Integer value) {
        if (value == null) {
            return null;
        }
        return AnnotationValue.createIntegerValue((String)name, (int)value);
    }

    static void integerValue(String name, Integer value, List<AnnotationValue> annotationValueList) {
        MockHelper.addToCollectionIfNotNull(annotationValueList, MockHelper.integerValue(name, value));
    }

    static AnnotationValue[] booleanValueArray(String name, Boolean value) {
        return MockHelper.nullSafe(MockHelper.booleanValue(name, value));
    }

    static void booleanValue(String name, Boolean value, List<AnnotationValue> annotationValueList) {
        MockHelper.addToCollectionIfNotNull(annotationValueList, MockHelper.booleanValue(name, value));
    }

    private static AnnotationValue booleanValue(String name, Boolean value) {
        if (value == null) {
            return null;
        }
        return AnnotationValue.createBooleanValue((String)name, (boolean)value);
    }

    private static AnnotationValue classValue(String name, String className, ServiceRegistry serviceRegistry) {
        if (StringHelper.isNotEmpty(className)) {
            return AnnotationValue.createClassValue((String)name, (Type)MockHelper.getType(className, serviceRegistry));
        }
        return null;
    }

    static void classValue(String name, String className, List<AnnotationValue> list, ServiceRegistry serviceRegistry) {
        MockHelper.addToCollectionIfNotNull(list, MockHelper.classValue(name, className, serviceRegistry));
    }

    static AnnotationValue[] classValueArray(String name, String className, ServiceRegistry serviceRegistry) {
        return MockHelper.nullSafe(MockHelper.classValue(name, className, serviceRegistry));
    }

    static AnnotationValue nestedAnnotationValue(String name, AnnotationInstance value) {
        if (value == null) {
            return null;
        }
        return AnnotationValue.createNestedAnnotationValue((String)name, (AnnotationInstance)value);
    }

    static void nestedAnnotationValue(String name, AnnotationInstance value, List<AnnotationValue> list) {
        MockHelper.addToCollectionIfNotNull(list, MockHelper.nestedAnnotationValue(name, value));
    }

    private static AnnotationValue[] nullSafe(AnnotationValue value) {
        AnnotationValue[] annotationValueArray;
        if (value == null) {
            annotationValueArray = EMPTY_ANNOTATION_VALUE_ARRAY;
        } else {
            AnnotationValue[] annotationValueArray2 = new AnnotationValue[1];
            annotationValueArray = annotationValueArray2;
            annotationValueArray2[0] = value;
        }
        return annotationValueArray;
    }

    static void classArrayValue(String name, List<String> classNameList, List<AnnotationValue> list, ServiceRegistry serviceRegistry) {
        if (MockHelper.isNotEmpty(classNameList)) {
            ArrayList<AnnotationValue> clazzValueList = new ArrayList<AnnotationValue>(classNameList.size());
            for (String clazz : classNameList) {
                MockHelper.addToCollectionIfNotNull(clazzValueList, MockHelper.classValue("", clazz, serviceRegistry));
            }
            list.add(AnnotationValue.createArrayValue((String)name, (AnnotationValue[])MockHelper.toArray(clazzValueList)));
        }
    }

    public static AnnotationValue[] toArray(List<AnnotationValue> list) {
        AnnotationValue[] values = EMPTY_ANNOTATION_VALUE_ARRAY;
        if (MockHelper.isNotEmpty(list)) {
            values = list.toArray(new AnnotationValue[list.size()]);
        }
        return values;
    }

    private static AnnotationValue enumValue(String name, DotName typeName, Enum value) {
        if (value != null && StringHelper.isNotEmpty(value.toString())) {
            return AnnotationValue.createEnumValue((String)name, (DotName)typeName, (String)value.toString());
        }
        return null;
    }

    static void cascadeValue(String name, XMLCascadeType cascadeType, boolean isCascadePersistDefault, List<AnnotationValue> annotationValueList) {
        ArrayList<Enum> enumList = new ArrayList<Enum>();
        if (isCascadePersistDefault) {
            enumList.add((Enum)CascadeType.PERSIST);
        }
        if (cascadeType != null) {
            if (cascadeType.getCascadeAll() != null) {
                enumList.add((Enum)CascadeType.ALL);
            }
            if (cascadeType.getCascadePersist() != null && !isCascadePersistDefault) {
                enumList.add((Enum)CascadeType.PERSIST);
            }
            if (cascadeType.getCascadeMerge() != null) {
                enumList.add((Enum)CascadeType.MERGE);
            }
            if (cascadeType.getCascadeRemove() != null) {
                enumList.add((Enum)CascadeType.REMOVE);
            }
            if (cascadeType.getCascadeRefresh() != null) {
                enumList.add((Enum)CascadeType.REFRESH);
            }
            if (cascadeType.getCascadeDetach() != null) {
                enumList.add((Enum)CascadeType.DETACH);
            }
        }
        if (!enumList.isEmpty()) {
            MockHelper.enumArrayValue(name, JPADotNames.CASCADE_TYPE, enumList, annotationValueList);
        }
    }

    static void enumArrayValue(String name, DotName typeName, List<Enum> valueList, List<AnnotationValue> list) {
        if (MockHelper.isNotEmpty(valueList)) {
            ArrayList<AnnotationValue> enumValueList = new ArrayList<AnnotationValue>(valueList.size());
            for (Enum e : valueList) {
                MockHelper.addToCollectionIfNotNull(enumValueList, MockHelper.enumValue("", typeName, e));
            }
            list.add(AnnotationValue.createArrayValue((String)name, (AnnotationValue[])MockHelper.toArray(enumValueList)));
        }
    }

    static void enumValue(String name, DotName typeName, Enum value, List<AnnotationValue> list) {
        MockHelper.addToCollectionIfNotNull(list, MockHelper.enumValue(name, typeName, value));
    }

    static AnnotationValue[] enumValueArray(String name, DotName typeName, Enum value) {
        return MockHelper.nullSafe(MockHelper.enumValue(name, typeName, value));
    }

    public static void addToCollectionIfNotNull(Collection collection, Object value) {
        if (value != null && collection != null) {
            collection.add(value);
        }
    }

    public static boolean targetEquals(AnnotationTarget t1, AnnotationTarget t2) {
        if (t1 == t2) {
            return true;
        }
        if (t1 != null && t2 != null && t1.getClass() == t2.getClass()) {
            if (t1.getClass() == ClassInfo.class) {
                return ((ClassInfo)t1).name().equals((Object)((ClassInfo)t2).name());
            }
            if (t1.getClass() == MethodInfo.class) {
                return ((MethodInfo)t1).name().equals(((MethodInfo)t2).name());
            }
            return ((FieldInfo)t1).name().equals(((FieldInfo)t2).name());
        }
        return false;
    }

    public static boolean isNotEmpty(Collection collection) {
        return collection != null && !collection.isEmpty();
    }

    static AnnotationInstance create(DotName name, AnnotationTarget target, List<AnnotationValue> annotationValueList) {
        return MockHelper.create(name, target, MockHelper.toArray(annotationValueList));
    }

    static String buildSafeClassName(String className, String defaultPackageName) {
        if (className.indexOf(46) < 0 && StringHelper.isNotEmpty(defaultPackageName)) {
            className = StringHelper.qualify(defaultPackageName, className);
        }
        return className;
    }

    static AnnotationInstance create(DotName name, AnnotationTarget target, AnnotationValue[] values) {
        if (values == null || values.length == 0) {
            values = EMPTY_ANNOTATION_VALUE_ARRAY;
        }
        return AnnotationInstance.create((DotName)name, (AnnotationTarget)target, (AnnotationValue[])MockHelper.addMockMark(values));
    }

    private static AnnotationValue[] addMockMark(AnnotationValue[] values) {
        AnnotationValue[] newValues = new AnnotationValue[values.length + 1];
        System.arraycopy(values, 0, newValues, 0, values.length);
        newValues[values.length] = MockHelper.booleanValue("isMocked", true);
        return newValues;
    }

    private static MethodInfo getMethodInfo(ClassInfo classInfo, Method method) {
        Class<?> returnTypeClass = method.getReturnType();
        short access_flags = (short)method.getModifiers();
        return MethodInfo.create((ClassInfo)classInfo, (String)method.getName(), (Type[])MockHelper.getTypes(method.getParameterTypes()), (Type)MockHelper.getType(returnTypeClass), (short)access_flags);
    }

    static AnnotationTarget getTarget(ServiceRegistry serviceRegistry, ClassInfo classInfo, String name, TargetType type) {
        Class clazz = serviceRegistry.getService(ClassLoaderService.class).classForName(classInfo.toString());
        switch (type) {
            case FIELD: {
                Field field = MockHelper.getField(clazz, name);
                if (field == null) {
                    throw new HibernateException("Unable to load field " + name + " of class " + clazz.getName());
                }
                return FieldInfo.create((ClassInfo)classInfo, (String)name, (Type)MockHelper.getType(field.getType()), (short)((short)field.getModifiers()));
            }
            case METHOD: {
                Method method = MockHelper.getMethod(clazz, name);
                if (method == null) {
                    throw new HibernateException("Unable to load method " + name + " of class " + clazz.getName());
                }
                return MockHelper.getMethodInfo(classInfo, method);
            }
            case PROPERTY: {
                Method method = MockHelper.getterMethod(clazz, name);
                if (method == null) {
                    throw new HibernateException("Unable to load property " + name + " of class " + clazz.getName());
                }
                return MockHelper.getMethodInfo(classInfo, method);
            }
        }
        throw new HibernateException("");
    }

    private static Method getterMethod(Class theClass, String propertyName) {
        AccessibleObject[] methods = theClass.getDeclaredMethods();
        Method.setAccessible(methods, true);
        for (AccessibleObject method : methods) {
            String testOldMethod;
            String testStdMethod;
            if (((Method)method).getParameterTypes().length != 0 || ((Method)method).isBridge()) continue;
            String methodName = ((Method)method).getName();
            if (methodName.startsWith("get") || methodName.startsWith("has")) {
                testStdMethod = Introspector.decapitalize(methodName.substring(3));
                testOldMethod = methodName.substring(3);
                if (testStdMethod.equals(propertyName) || testOldMethod.equals(propertyName)) {
                    return method;
                }
            }
            if (!methodName.startsWith("is")) continue;
            testStdMethod = Introspector.decapitalize(methodName.substring(2));
            testOldMethod = methodName.substring(2);
            if (!testStdMethod.equals(propertyName) && !testOldMethod.equals(propertyName)) continue;
            return method;
        }
        return null;
    }

    private static Method getMethod(Class theClass, String propertyName) {
        AccessibleObject[] methods = theClass.getDeclaredMethods();
        Method.setAccessible(methods, true);
        for (AccessibleObject method : methods) {
            String methodName;
            if (((Method)method).getParameterTypes().length != 0 || ((Method)method).isBridge() || !(methodName = ((Method)method).getName()).equals(propertyName)) continue;
            return method;
        }
        return null;
    }

    private static Field getField(Class clazz, String name) {
        AccessibleObject[] fields = clazz.getDeclaredFields();
        Field.setAccessible(fields, true);
        for (AccessibleObject field : fields) {
            if (!((Field)field).getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    private static Type[] getTypes(Class[] classes) {
        if (classes == null || classes.length == 0) {
            return EMPTY_TYPE_ARRAY;
        }
        Type[] types = new Type[classes.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = MockHelper.getType(classes[i]);
        }
        return types;
    }

    private static Type getType(String className, ServiceRegistry serviceRegistry) {
        return MockHelper.getType(serviceRegistry.getService(ClassLoaderService.class).classForName(className));
    }

    private static Type getType(Class clazz) {
        return Type.create((DotName)DotName.createSimple((String)clazz.getName()), (Type.Kind)MockHelper.getTypeKind(clazz));
    }

    private static Type.Kind getTypeKind(Class clazz) {
        Type.Kind kind = clazz == Void.TYPE ? Type.Kind.VOID : (clazz.isPrimitive() ? Type.Kind.PRIMITIVE : (clazz.isArray() ? Type.Kind.ARRAY : Type.Kind.CLASS));
        return kind;
    }

    static enum TargetType {
        METHOD,
        FIELD,
        PROPERTY;

    }
}

