/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.attribute;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.metamodel.source.annotations.AnnotationBindingContext;
import org.hibernate.metamodel.source.annotations.HibernateDotNames;
import org.hibernate.metamodel.source.annotations.JandexHelper;
import org.hibernate.metamodel.source.annotations.attribute.AttributeType;
import org.hibernate.metamodel.source.annotations.attribute.BasicAttribute;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;

public class AssociationAttribute
extends BasicAttribute {
    private final AttributeType associationType;
    private final boolean ignoreNotFound;
    private final String referencedEntityType;
    private final Set<CascadeType> cascadeTypes;

    public static AssociationAttribute createAssociationAttribute(String name, Class<?> attributeType, AttributeType attributeNature, String accessType, Map<DotName, List<AnnotationInstance>> annotations, AnnotationBindingContext context) {
        return new AssociationAttribute(name, attributeType, attributeNature, accessType, annotations, context);
    }

    private AssociationAttribute(String name, Class<?> javaType, AttributeType associationType, String accessType, Map<DotName, List<AnnotationInstance>> annotations, AnnotationBindingContext context) {
        super(name, javaType, accessType, annotations, context);
        this.associationType = associationType;
        this.ignoreNotFound = this.ignoreNotFound();
        AnnotationInstance associationAnnotation = JandexHelper.getSingleAnnotation(annotations, associationType.getAnnotationDotName());
        this.referencedEntityType = this.determineReferencedEntityType(associationAnnotation);
        this.cascadeTypes = this.determineCascadeTypes(associationAnnotation);
    }

    public boolean isIgnoreNotFound() {
        return this.ignoreNotFound;
    }

    public String getReferencedEntityType() {
        return this.referencedEntityType;
    }

    public AttributeType getAssociationType() {
        return this.associationType;
    }

    public Set<CascadeType> getCascadeTypes() {
        return this.cascadeTypes;
    }

    private boolean ignoreNotFound() {
        AnnotationValue actionValue;
        NotFoundAction action = NotFoundAction.EXCEPTION;
        AnnotationInstance notFoundAnnotation = JandexHelper.getSingleAnnotation(this.annotations(), HibernateDotNames.NOT_FOUND);
        if (notFoundAnnotation != null && (actionValue = notFoundAnnotation.value("action")) != null) {
            action = Enum.valueOf(NotFoundAction.class, actionValue.asEnum());
        }
        return NotFoundAction.IGNORE.equals((Object)action);
    }

    private String determineReferencedEntityType(AnnotationInstance associationAnnotation) {
        AnnotationValue targetEntityValue;
        String targetTypeName = this.getAttributeType().getName();
        AnnotationInstance targetAnnotation = JandexHelper.getSingleAnnotation(this.annotations(), HibernateDotNames.TARGET);
        if (targetAnnotation != null) {
            targetTypeName = targetAnnotation.value().asClass().name().toString();
        }
        if ((targetEntityValue = associationAnnotation.value("targetEntity")) != null) {
            targetTypeName = targetEntityValue.asClass().name().toString();
        }
        return targetTypeName;
    }

    private Set<CascadeType> determineCascadeTypes(AnnotationInstance associationAnnotation) {
        HashSet<CascadeType> cascadeTypes = new HashSet<CascadeType>();
        AnnotationValue cascadeValue = associationAnnotation.value("cascade");
        if (cascadeValue != null) {
            String[] cascades;
            for (String s : cascades = cascadeValue.asEnumArray()) {
                cascadeTypes.add(Enum.valueOf(CascadeType.class, s));
            }
        }
        return cascadeTypes;
    }
}

