/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.internal;

import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.VersionType;
import org.jboss.logging.Logger;

public final class Versioning {
    public static final int OPTIMISTIC_LOCK_NONE = -1;
    public static final int OPTIMISTIC_LOCK_VERSION = 0;
    public static final int OPTIMISTIC_LOCK_ALL = 2;
    public static final int OPTIMISTIC_LOCK_DIRTY = 1;
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)Versioning.class.getName());

    private Versioning() {
    }

    private static Object seed(VersionType versionType, SessionImplementor session) {
        Object seed = versionType.seed(session);
        LOG.trace("Seeding: " + seed);
        return seed;
    }

    public static boolean seedVersion(Object[] fields, int versionProperty, VersionType versionType, SessionImplementor session) {
        Object initialVersion = fields[versionProperty];
        if (initialVersion == null || initialVersion instanceof Number && ((Number)initialVersion).longValue() < 0L) {
            fields[versionProperty] = Versioning.seed(versionType, session);
            return true;
        }
        LOG.trace("Using initial version: " + initialVersion);
        return false;
    }

    public static Object increment(Object version, VersionType versionType, SessionImplementor session) {
        Object next = versionType.next(version, session);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Incrementing: " + versionType.toLoggableString(version, session.getFactory()) + " to " + versionType.toLoggableString(next, session.getFactory()));
        }
        return next;
    }

    public static void setVersion(Object[] fields, Object version, EntityPersister persister) {
        if (!persister.isVersioned()) {
            return;
        }
        fields[persister.getVersionProperty()] = version;
    }

    public static Object getVersion(Object[] fields, EntityPersister persister) {
        if (!persister.isVersioned()) {
            return null;
        }
        return fields[persister.getVersionProperty()];
    }

    public static boolean isVersionIncrementRequired(int[] dirtyProperties, boolean hasDirtyCollections, boolean[] propertyVersionability) {
        if (hasDirtyCollections) {
            return true;
        }
        for (int i = 0; i < dirtyProperties.length; ++i) {
            if (!propertyVersionability[dirtyProperties[i]]) continue;
            return true;
        }
        return false;
    }
}

