/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.type.StandardBasicTypes;

public class SQLServer2005Dialect
extends SQLServerDialect {
    private static final String SELECT = "select";
    private static final String FROM = "from";
    private static final String DISTINCT = "distinct";
    private static final int MAX_LENGTH = 8000;

    public SQLServer2005Dialect() {
        this.registerColumnType(2004, "varbinary(MAX)");
        this.registerColumnType(-3, "varbinary(MAX)");
        this.registerColumnType(-3, 8000L, "varbinary($l)");
        this.registerColumnType(-4, "varbinary(MAX)");
        this.registerColumnType(2005, "varchar(MAX)");
        this.registerColumnType(-1, "varchar(MAX)");
        this.registerColumnType(12, "varchar(MAX)");
        this.registerColumnType(12, 8000L, "varchar($l)");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(-7, "bit");
        this.registerColumnType(16, "bit");
        this.registerFunction("row_number", new NoArgSQLFunction("row_number", StandardBasicTypes.INTEGER, true));
    }

    @Override
    public boolean supportsLimitOffset() {
        return true;
    }

    @Override
    public boolean bindLimitParametersFirst() {
        return false;
    }

    @Override
    public boolean supportsVariableLimit() {
        return true;
    }

    @Override
    public int convertToFirstRowValue(int zeroBasedFirstResult) {
        return zeroBasedFirstResult + 1;
    }

    @Override
    public String getLimitString(String query, int offset, int limit) {
        if (offset > 1 || limit > 1) {
            return this.getLimitString(query, true);
        }
        return query;
    }

    @Override
    public String getLimitString(String querySqlString, boolean hasOffset) {
        String orderby;
        StringBuilder sb = new StringBuilder(querySqlString.trim().toLowerCase());
        int orderByIndex = sb.indexOf("order by");
        CharSequence charSequence = orderby = orderByIndex > 0 ? sb.subSequence(orderByIndex, sb.length()) : "ORDER BY CURRENT_TIMESTAMP";
        if (orderByIndex > 0) {
            sb.delete(orderByIndex, orderByIndex + orderby.length());
        }
        SQLServer2005Dialect.replaceDistinctWithGroupBy(sb);
        SQLServer2005Dialect.insertRowNumberFunction(sb, orderby);
        sb.insert(0, "WITH query AS (").append(") SELECT * FROM query ");
        sb.append("WHERE __hibernate_row_nr__ BETWEEN ? AND ?");
        return sb.toString();
    }

    protected static void replaceDistinctWithGroupBy(StringBuilder sql) {
        int distinctIndex = sql.indexOf(DISTINCT);
        if (distinctIndex > 0) {
            sql.delete(distinctIndex, distinctIndex + DISTINCT.length() + 1);
            sql.append(" group by").append(SQLServer2005Dialect.getSelectFieldsWithoutAliases(sql));
        }
    }

    protected static CharSequence getSelectFieldsWithoutAliases(StringBuilder sql) {
        String select = sql.substring(sql.indexOf(SELECT) + SELECT.length(), sql.indexOf(FROM));
        return SQLServer2005Dialect.stripAliases(select);
    }

    protected static String stripAliases(String str) {
        return str.replaceAll("\\sas[^,]+(,?)", "$1");
    }

    protected static void insertRowNumberFunction(StringBuilder sql, CharSequence orderby) {
        int selectEndIndex = sql.indexOf(SELECT) + SELECT.length();
        sql.insert(selectEndIndex, " ROW_NUMBER() OVER (" + orderby + ") as __hibernate_row_nr__,");
    }
}

