/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import org.h2.api.DatabaseEventListener;
import org.h2.command.Prepared;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.message.DbException;
import org.h2.result.SearchRow;
import org.h2.value.ValueInt;
import org.h2.value.ValueString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaRecord
implements Comparable<MetaRecord> {
    private int id;
    private int objectType;
    private String sql;

    public MetaRecord(SearchRow searchRow) {
        this.id = searchRow.getValue(0).getInt();
        this.objectType = searchRow.getValue(2).getInt();
        this.sql = searchRow.getValue(3).getString();
    }

    MetaRecord(DbObject dbObject) {
        this.id = dbObject.getId();
        this.objectType = dbObject.getType();
        this.sql = dbObject.getCreateSQL();
    }

    void setRecord(SearchRow searchRow) {
        searchRow.setValue(0, ValueInt.get(this.id));
        searchRow.setValue(1, ValueInt.get(0));
        searchRow.setValue(2, ValueInt.get(this.objectType));
        searchRow.setValue(3, ValueString.get(this.sql));
    }

    void execute(Database database, Session session, DatabaseEventListener databaseEventListener) {
        try {
            Prepared prepared = session.prepare(this.sql);
            prepared.setObjectId(this.id);
            prepared.update();
        }
        catch (DbException dbException) {
            DbException dbException2 = dbException.addSQL(this.sql);
            SQLException sQLException = dbException2.getSQLException();
            database.getTrace("database").error(this.sql, sQLException);
            if (databaseEventListener != null) {
                databaseEventListener.exceptionThrown(sQLException, this.sql);
            }
            throw dbException2;
        }
    }

    public int getId() {
        return this.id;
    }

    public int getObjectType() {
        return this.objectType;
    }

    public String getSQL() {
        return this.sql;
    }

    @Override
    public int compareTo(MetaRecord metaRecord) {
        int n;
        int n2 = this.getCreateOrder(this.getObjectType());
        if (n2 != (n = this.getCreateOrder(metaRecord.getObjectType()))) {
            return n2 - n;
        }
        return this.getId() - metaRecord.getId();
    }

    private int getCreateOrder(int n) {
        switch (n) {
            case 6: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 10: {
                return 2;
            }
            case 9: {
                return 3;
            }
            case 12: {
                return 4;
            }
            case 3: {
                return 5;
            }
            case 11: {
                return 6;
            }
            case 0: {
                return 7;
            }
            case 1: {
                return 8;
            }
            case 5: {
                return 9;
            }
            case 4: {
                return 10;
            }
            case 7: {
                return 11;
            }
            case 8: {
                return 12;
            }
            case 14: {
                return 13;
            }
            case 13: {
                return 14;
            }
        }
        throw DbException.throwInternalError("type=" + n);
    }
}

