/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command;

import java.util.ArrayList;
import org.h2.command.Command;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.expression.Parameter;
import org.h2.expression.ParameterInterface;
import org.h2.result.ResultInterface;
import org.h2.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandContainer
extends Command {
    private Prepared prepared;

    CommandContainer(Parser parser, String string, Prepared prepared) {
        super(parser, string);
        prepared.setCommand(this);
        this.prepared = prepared;
    }

    @Override
    public ArrayList<? extends ParameterInterface> getParameters() {
        return this.prepared.getParameters();
    }

    @Override
    public boolean isTransactional() {
        return this.prepared.isTransactional();
    }

    @Override
    public boolean isQuery() {
        return this.prepared.isQuery();
    }

    private void recompileIfRequired() {
        if (this.prepared.needRecompile()) {
            this.prepared.setModificationMetaId(0L);
            String string = this.prepared.getSQL();
            ArrayList<Parameter> arrayList = this.prepared.getParameters();
            Parser parser = new Parser(this.session);
            this.prepared = parser.parse(string);
            long l = this.prepared.getModificationMetaId();
            this.prepared.setModificationMetaId(0L);
            ArrayList<Parameter> arrayList2 = this.prepared.getParameters();
            int n = arrayList2.size();
            for (int i = 0; i < n; ++i) {
                Parameter parameter = arrayList.get(i);
                if (!parameter.isValueSet()) continue;
                Value value = parameter.getValue(this.session);
                Parameter parameter2 = arrayList2.get(i);
                parameter2.setValue(value);
            }
            this.prepared.prepare();
            this.prepared.setModificationMetaId(l);
        }
    }

    @Override
    public int update() {
        this.recompileIfRequired();
        this.start();
        this.prepared.checkParameters();
        int n = this.prepared.update();
        this.prepared.trace(this.startTime, n);
        return n;
    }

    @Override
    public ResultInterface query(int n) {
        this.recompileIfRequired();
        this.start();
        this.prepared.checkParameters();
        ResultInterface resultInterface = this.prepared.query(n);
        this.prepared.trace(this.startTime, resultInterface.getRowCount());
        return resultInterface;
    }

    @Override
    public boolean isReadOnly() {
        return this.prepared.isReadOnly();
    }

    @Override
    public ResultInterface queryMeta() {
        return this.prepared.queryMeta();
    }

    @Override
    public boolean isCacheable() {
        return this.prepared.isCacheable();
    }

    @Override
    public int getCommandType() {
        return this.prepared.getType();
    }
}

