/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jmx.JMXConnectorService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

class JMXConnectorAdd
implements OperationStepHandler {
    static final JMXConnectorAdd INSTANCE = new JMXConnectorAdd();
    static final String OPERATION_NAME = "add-connector";

    private JMXConnectorAdd() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource subsystem = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        ModelNode model = subsystem.getModel();
        final String serverBinding = operation.require("server-binding").asString();
        final String registryBinding = operation.require("registry-binding").asString();
        model.get("server-binding").set(serverBinding);
        model.get("registry-binding").set(registryBinding);
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceTarget target = context.getServiceTarget();
                    ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
                    JMXConnectorService.addService(target, serverBinding, registryBinding, new ServiceListener[]{verificationHandler});
                    context.addStep((OperationStepHandler)verificationHandler, OperationContext.Stage.VERIFY);
                    if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
                        context.removeService(JMXConnectorService.SERVICE_NAME);
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }
}

