/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.tx.noopts;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;

public class TransactionImpl
implements Transaction,
Serializable {
    private static final long serialVersionUID = 1L;
    private int status = 0;
    private Set<Synchronization> syncs = null;
    private Set<XAResource> xas = null;

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.finish(3);
    }

    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        if (this.xas == null) {
            return false;
        }
        return this.xas.remove(xaRes);
    }

    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        if (this.xas == null) {
            this.xas = new HashSet<XAResource>(1);
        }
        return this.xas.add(xaRes);
    }

    public int getStatus() throws SystemException {
        return this.status;
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        if (this.syncs == null) {
            this.syncs = new HashSet<Synchronization>(1);
        }
        this.syncs.add(sync);
    }

    public void rollback() throws IllegalStateException, SystemException {
        this.finish(4);
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.status = 1;
    }

    boolean getRollbackOnly() {
        return this.status == 1;
    }

    private void finish(int st) {
        if (this.syncs != null) {
            for (Synchronization s : this.syncs) {
                s.beforeCompletion();
            }
        }
        this.status = st;
        if (this.syncs != null) {
            for (Synchronization s : this.syncs) {
                s.afterCompletion(this.status);
            }
        }
    }
}

