/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.connectionmanager.pool.mcp;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.jca.core.connectionmanager.pool.mcp.ManagedConnectionPoolStatistics;

public class ManagedConnectionPoolStatisticsImpl
implements ManagedConnectionPoolStatistics {
    private static final long serialVersionUID = 1L;
    private static final String ACTIVE_COUNT = "ActiveCount";
    private static final String AVAILABLE_COUNT = "AvailableCount";
    private static final String AVERAGE_BLOCKING_TIME = "AverageBlockingTime";
    private static final String AVERAGE_CREATION_TIME = "AverageCreationTime";
    private static final String CREATED_COUNT = "CreatedCount";
    private static final String DESTROYED_COUNT = "DestroyedCount";
    private static final String MAX_CREATION_TIME = "MaxCreationTime";
    private static final String MAX_USED_COUNT = "MaxUsedCount";
    private static final String MAX_WAIT_COUNT = "MaxWaitCount";
    private static final String MAX_WAIT_TIME = "MaxWaitTime";
    private static final String TIMED_OUT = "TimedOut";
    private static final String TOTAL_BLOCKING_TIME = "TotalBlockingTime";
    private static final String TOTAL_CREATION_TIME = "TotalCreationTime";
    private int maxPoolSize;
    private Set<String> names;
    private Map<String, Class> types;
    private Map<Locale, ResourceBundle> rbs;
    private AtomicInteger createdCount;
    private AtomicInteger destroyedCount;
    private AtomicInteger maxUsedCount;
    private AtomicLong maxCreationTime;
    private AtomicInteger maxWaitCount;
    private AtomicLong maxWaitTime;
    private AtomicInteger timedOut;
    private AtomicLong totalBlockingTime;
    private AtomicLong totalCreationTime;
    private AtomicInteger inUseCount;

    public ManagedConnectionPoolStatisticsImpl(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        HashSet<String> n = new HashSet<String>();
        HashMap<String, Class<Number>> t = new HashMap<String, Class<Number>>();
        n.add(ACTIVE_COUNT);
        t.put(ACTIVE_COUNT, Integer.TYPE);
        n.add(AVAILABLE_COUNT);
        t.put(AVAILABLE_COUNT, Integer.TYPE);
        n.add(AVERAGE_BLOCKING_TIME);
        t.put(AVERAGE_BLOCKING_TIME, Long.TYPE);
        n.add(AVERAGE_CREATION_TIME);
        t.put(AVERAGE_CREATION_TIME, Long.TYPE);
        n.add(CREATED_COUNT);
        t.put(CREATED_COUNT, Integer.TYPE);
        n.add(DESTROYED_COUNT);
        t.put(DESTROYED_COUNT, Integer.TYPE);
        n.add(MAX_CREATION_TIME);
        t.put(MAX_CREATION_TIME, Long.TYPE);
        n.add(MAX_USED_COUNT);
        t.put(MAX_USED_COUNT, Integer.TYPE);
        n.add(MAX_WAIT_COUNT);
        t.put(MAX_WAIT_COUNT, Integer.TYPE);
        n.add(MAX_WAIT_TIME);
        t.put(MAX_WAIT_TIME, Long.TYPE);
        n.add(TIMED_OUT);
        t.put(TIMED_OUT, Integer.TYPE);
        n.add(TOTAL_BLOCKING_TIME);
        t.put(TOTAL_BLOCKING_TIME, Long.TYPE);
        n.add(TOTAL_CREATION_TIME);
        t.put(TOTAL_CREATION_TIME, Long.TYPE);
        this.names = Collections.unmodifiableSet(n);
        this.types = Collections.unmodifiableMap(t);
        ResourceBundle defaultResourceBundle = ResourceBundle.getBundle("poolstatistics", Locale.US, ManagedConnectionPoolStatisticsImpl.class.getClassLoader());
        this.rbs = new HashMap<Locale, ResourceBundle>(1);
        this.rbs.put(Locale.US, defaultResourceBundle);
        this.createdCount = new AtomicInteger(0);
        this.destroyedCount = new AtomicInteger(0);
        this.maxCreationTime = new AtomicLong(Long.MIN_VALUE);
        this.maxUsedCount = new AtomicInteger(Integer.MIN_VALUE);
        this.maxWaitCount = new AtomicInteger(Integer.MIN_VALUE);
        this.maxWaitTime = new AtomicLong(Long.MIN_VALUE);
        this.timedOut = new AtomicInteger(0);
        this.totalBlockingTime = new AtomicLong(0L);
        this.totalCreationTime = new AtomicLong(0L);
        this.inUseCount = new AtomicInteger(0);
    }

    public Set<String> getNames() {
        return this.names;
    }

    public Class getType(String name) {
        return this.types.get(name);
    }

    public String getDescription(String name) {
        return this.getDescription(name, Locale.US);
    }

    public String getDescription(String name, Locale locale) {
        ResourceBundle newResourceBundle;
        ResourceBundle rb = this.rbs.get(locale);
        if (rb == null && (newResourceBundle = ResourceBundle.getBundle("poolstatistics", locale, ManagedConnectionPoolStatisticsImpl.class.getClassLoader())) != null) {
            this.rbs.put(locale, newResourceBundle);
        }
        if (rb == null) {
            rb = this.rbs.get(Locale.US);
        }
        if (rb != null) {
            return rb.getString(name);
        }
        return "";
    }

    public Object getValue(String name) {
        if (ACTIVE_COUNT.equals(name)) {
            return this.getActiveCount();
        }
        if (AVAILABLE_COUNT.equals(name)) {
            return this.getAvailableCount();
        }
        if (AVERAGE_BLOCKING_TIME.equals(name)) {
            return this.getAverageBlockingTime();
        }
        if (AVERAGE_CREATION_TIME.equals(name)) {
            return this.getAverageCreationTime();
        }
        if (CREATED_COUNT.equals(name)) {
            return this.getCreatedCount();
        }
        if (DESTROYED_COUNT.equals(name)) {
            return this.getDestroyedCount();
        }
        if (MAX_CREATION_TIME.equals(name)) {
            return this.getMaxCreationTime();
        }
        if (MAX_USED_COUNT.equals(name)) {
            return this.getMaxUsedCount();
        }
        if (MAX_WAIT_COUNT.equals(name)) {
            return this.getMaxWaitCount();
        }
        if (MAX_WAIT_TIME.equals(name)) {
            return this.getMaxWaitTime();
        }
        if (TIMED_OUT.equals(name)) {
            return this.getTimedOut();
        }
        if (TOTAL_BLOCKING_TIME.equals(name)) {
            return this.getTotalBlockingTime();
        }
        if (TOTAL_CREATION_TIME.equals(name)) {
            return this.getTotalCreationTime();
        }
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public void setEnabled(boolean v) {
    }

    public int getActiveCount() {
        return this.createdCount.get() - this.destroyedCount.get();
    }

    public int getAvailableCount() {
        return this.maxPoolSize - this.inUseCount.get();
    }

    public long getAverageBlockingTime() {
        return this.createdCount.get() != 0 ? this.totalBlockingTime.get() / (long)this.createdCount.get() : 0L;
    }

    public long getAverageCreationTime() {
        return this.createdCount.get() != 0 ? this.totalCreationTime.get() / (long)this.createdCount.get() : 0L;
    }

    public int getCreatedCount() {
        return this.createdCount.get();
    }

    public void deltaCreatedCount() {
        this.createdCount.incrementAndGet();
    }

    public int getDestroyedCount() {
        return this.destroyedCount.get();
    }

    public void deltaDestroyedCount() {
        this.destroyedCount.incrementAndGet();
    }

    public int getMaxUsedCount() {
        return this.maxUsedCount.get() != Integer.MIN_VALUE ? this.maxUsedCount.get() : 0;
    }

    public void setInUsedCount(int v) {
        this.inUseCount.set(v);
        this.setMaxUsedCount(v);
    }

    public void setMaxUsedCount(int v) {
        if (v > this.maxUsedCount.get()) {
            this.maxUsedCount.set(v);
        }
    }

    public int getMaxWaitCount() {
        return this.maxWaitCount.get() != Integer.MIN_VALUE ? this.maxWaitCount.get() : 0;
    }

    public void setMaxWaitCount(int v) {
        if (v > this.maxWaitCount.get()) {
            this.maxWaitCount.set(v);
        }
    }

    public long getMaxCreationTime() {
        return this.maxCreationTime.get() != Long.MIN_VALUE ? this.maxCreationTime.get() : 0L;
    }

    public long getMaxWaitTime() {
        return this.maxWaitTime.get() != Long.MIN_VALUE ? this.maxWaitTime.get() : 0L;
    }

    public int getTimedOut() {
        return this.timedOut.get();
    }

    public void deltaTimedOut() {
        this.timedOut.incrementAndGet();
    }

    public long getTotalBlockingTime() {
        return this.totalBlockingTime.get();
    }

    public void deltaTotalBlockingTime(long delta) {
        if (delta > 0L) {
            this.totalBlockingTime.addAndGet(delta);
            if (delta > this.maxWaitTime.get()) {
                this.maxWaitTime.set(delta);
            }
        }
    }

    public long getTotalCreationTime() {
        return this.totalCreationTime.get();
    }

    public void deltaTotalCreationTime(long delta) {
        if (delta > 0L) {
            this.totalCreationTime.addAndGet(delta);
            if (delta > this.maxCreationTime.get()) {
                this.maxCreationTime.set(delta);
            }
        }
    }

    public void clear() {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ManagedConnectionPoolStatistics@").append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("[");
        sb.append(ACTIVE_COUNT).append("=").append(this.getActiveCount());
        sb.append(",");
        sb.append(AVAILABLE_COUNT).append("=").append(this.getAvailableCount());
        sb.append(",");
        sb.append(AVERAGE_BLOCKING_TIME).append("=").append(this.getAverageBlockingTime());
        sb.append(",");
        sb.append(AVERAGE_CREATION_TIME).append("=").append(this.getAverageCreationTime());
        sb.append(",");
        sb.append(CREATED_COUNT).append("=").append(this.getCreatedCount());
        sb.append(",");
        sb.append(DESTROYED_COUNT).append("=").append(this.getDestroyedCount());
        sb.append(",");
        sb.append(MAX_CREATION_TIME).append("=").append(this.getMaxCreationTime());
        sb.append(",");
        sb.append(MAX_USED_COUNT).append("=").append(this.getMaxUsedCount());
        sb.append(",");
        sb.append(MAX_WAIT_COUNT).append("=").append(this.getMaxWaitCount());
        sb.append(",");
        sb.append(MAX_WAIT_TIME).append("=").append(this.getMaxWaitTime());
        sb.append(",");
        sb.append(TIMED_OUT).append("=").append(this.getTimedOut());
        sb.append(",");
        sb.append(TOTAL_BLOCKING_TIME).append("=").append(this.getTotalBlockingTime());
        sb.append(",");
        sb.append(TOTAL_CREATION_TIME).append("=").append(this.getTotalCreationTime());
        sb.append("]");
        return sb.toString();
    }
}

