/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.remoting.Attribute;
import org.jboss.as.remoting.ConnectorAdd;
import org.jboss.as.remoting.ConnectorRemove;
import org.jboss.as.remoting.Element;
import org.jboss.as.remoting.Namespace;
import org.jboss.as.remoting.RemotingSubsystemAdd;
import org.jboss.as.remoting.RemotingSubsystemProviders;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.xnio.sasl.SaslQop;
import org.xnio.sasl.SaslStrength;

public class RemotingExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "remoting";

    public void initialize(ExtensionContext context) {
        SubsystemRegistration registration = context.registerSubsystem(SUBSYSTEM_NAME);
        registration.registerXMLElementWriter((XMLElementWriter)NewRemotingSubsystemParser.INSTANCE);
        ManagementResourceRegistration subsystem = registration.registerSubsystemModel(RemotingSubsystemProviders.SUBSYSTEM);
        subsystem.registerOperationHandler("add", RemotingSubsystemAdd.INSTANCE, RemotingSubsystemProviders.SUBSYSTEM_ADD, false);
        subsystem.registerOperationHandler("describe", (OperationStepHandler)RemotingSubsystemDescribeHandler.INSTANCE, (DescriptionProvider)RemotingSubsystemDescribeHandler.INSTANCE, false, OperationEntry.EntryType.PRIVATE);
        ManagementResourceRegistration connectors = subsystem.registerSubModel(PathElement.pathElement((String)"connector"), RemotingSubsystemProviders.CONNECTOR_SPEC);
        connectors.registerOperationHandler("add", (OperationStepHandler)ConnectorAdd.INSTANCE, (DescriptionProvider)ConnectorAdd.INSTANCE, false);
        connectors.registerOperationHandler("remove", (OperationStepHandler)ConnectorRemove.INSTANCE, (DescriptionProvider)ConnectorRemove.INSTANCE, false);
        connectors.registerSubModel(PathElement.pathElement((String)"sasl"), RemotingSubsystemProviders.SASL_SPEC);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.CURRENT.getUriString(), (XMLElementReader)NewRemotingSubsystemParser.INSTANCE);
    }

    private static class RemotingSubsystemDescribeHandler
    implements OperationStepHandler,
    DescriptionProvider {
        static final RemotingSubsystemDescribeHandler INSTANCE = new RemotingSubsystemDescribeHandler();

        private RemotingSubsystemDescribeHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            ModelNode result = context.getResult();
            ModelNode model = context.readModel(PathAddress.EMPTY_ADDRESS);
            PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)RemotingExtension.SUBSYSTEM_NAME)});
            ModelNode subsystem = new ModelNode();
            subsystem.get("operation").set("add");
            subsystem.get("address").set(address.toModelNode());
            subsystem.get("thread-pool").set(model.get("thread-pool"));
            result.add(subsystem);
            if (model.hasDefined("connector")) {
                for (Property prop : model.get("connector").asPropertyList()) {
                    ModelNode connector = prop.getValue();
                    ModelNode add = Util.getEmptyOperation((String)"add-connector", (ModelNode)address.append(new PathElement[]{PathElement.pathElement((String)"connector", (String)prop.getName())}).toModelNode());
                    if (connector.hasDefined("socket-binding")) {
                        add.get("socket-binding").set(connector.get("socket-binding"));
                    }
                    if (connector.hasDefined("authentication-provider")) {
                        add.get("authentication-provider").set("authentication-provider");
                    }
                    if (connector.hasDefined("sasl")) {
                        add.get("sasl");
                    }
                    result.add(connector);
                }
            }
            context.completeStep();
        }

        public ModelNode getModelDescription(Locale locale) {
            return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
        }
    }

    static final class NewRemotingSubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        private static final NewRemotingSubsystemParser INSTANCE = new NewRemotingSubsystemParser();

        NewRemotingSubsystemParser() {
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ModelNode address = new ModelNode();
            address.add("subsystem", RemotingExtension.SUBSYSTEM_NAME);
            address.protect();
            int count = reader.getAttributeCount();
            block9: for (int i = 0; i < count; ++i) {
                ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case THREAD_POOL: {
                        continue block9;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            ModelNode subsystem = Util.getEmptyOperation((String)"add", (ModelNode)address);
            list.add(subsystem);
            block10: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case REMOTING_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        switch (element) {
                            case CONNECTOR: {
                                this.parseConnector(reader, address, list);
                                continue block10;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }

        void parseConnector(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
            String name = null;
            String socketBinding = null;
            EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.SOCKET_BINDING);
            int count = reader.getAttributeCount();
            block12: for (int i = 0; i < count; ++i) {
                ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                required.remove((Object)attribute);
                switch (attribute) {
                    case NAME: {
                        name = value;
                        continue block12;
                    }
                    case SOCKET_BINDING: {
                        socketBinding = value;
                        continue block12;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (!required.isEmpty()) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
            }
            assert (name != null);
            assert (socketBinding != null);
            ModelNode connector = new ModelNode();
            connector.get("operation").set("add");
            connector.get("address").set(address).add("connector", name);
            connector.get("socket-binding").set(socketBinding);
            EnumSet<Element> visited = EnumSet.noneOf(Element.class);
            block13: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case REMOTING_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        if (visited.contains((Object)element)) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        visited.add(element);
                        switch (element) {
                            case SASL: {
                                connector.get("sasl").set(this.parseSaslElement(reader));
                                continue block13;
                            }
                            case PROPERTIES: {
                                this.parseProperties(reader, connector.get("properties"));
                                continue block13;
                            }
                            case AUTHENTICATION_PROVIDER: {
                                connector.get("authentication-provider").set(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"));
                                continue block13;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            list.add(connector);
        }

        ModelNode parseSaslElement(XMLExtendedStreamReader reader) throws XMLStreamException {
            ModelNode saslElement = new ModelNode();
            int count = reader.getAttributeCount();
            if (count > 0) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
            }
            EnumSet<Element> visited = EnumSet.noneOf(Element.class);
            block12: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case REMOTING_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        if (visited.contains((Object)element)) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        visited.add(element);
                        switch (element) {
                            case INCLUDE_MECHANISMS: {
                                ModelNode includes = saslElement.get("include-mechanisms");
                                for (String s : (String[])ParseUtils.readArrayAttributeElement((XMLExtendedStreamReader)reader, (String)"value", String.class)) {
                                    includes.add().set(s);
                                }
                                continue block12;
                            }
                            case POLICY: {
                                saslElement.get("policy").set(this.parsePolicyElement(reader));
                                continue block12;
                            }
                            case PROPERTIES: {
                                this.parseProperties(reader, saslElement.get("properties"));
                                continue block12;
                            }
                            case QOP: {
                                saslElement.get("qop").set(((SaslQop[])ParseUtils.readArrayAttributeElement((XMLExtendedStreamReader)reader, (String)"value", SaslQop.class)).toString());
                                continue block12;
                            }
                            case REUSE_SESSION: {
                                saslElement.get("reuse-session").set(ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                                continue block12;
                            }
                            case SERVER_AUTH: {
                                saslElement.get("server-auth").set(ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                                continue block12;
                            }
                            case STRENGTH: {
                                saslElement.get("strength").set(((SaslStrength[])ParseUtils.readArrayAttributeElement((XMLExtendedStreamReader)reader, (String)"value", SaslStrength.class)).toString());
                                continue block12;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            return saslElement;
        }

        ModelNode parsePolicyElement(XMLExtendedStreamReader reader) throws XMLStreamException {
            ModelNode policy = new ModelNode();
            if (reader.getAttributeCount() > 0) {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)0);
            }
            EnumSet<Element> visited = EnumSet.noneOf(Element.class);
            block11: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (Namespace.forUri(reader.getNamespaceURI())) {
                    case REMOTING_1_0: {
                        Element element = Element.forName(reader.getLocalName());
                        if (visited.contains((Object)element)) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        visited.add(element);
                        switch (element) {
                            case FORWARD_SECRECY: {
                                policy.get("forward-secrecy").set(ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                                continue block11;
                            }
                            case NO_ACTIVE: {
                                policy.get("no-active").set(ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                                continue block11;
                            }
                            case NO_ANONYMOUS: {
                                policy.set("no-anonymous").set(ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                                continue block11;
                            }
                            case NO_DICTIONARY: {
                                policy.get("no-dictionary").set(ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                                continue block11;
                            }
                            case NO_PLAINTEXT: {
                                policy.get("no-plaintext").set(ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                                continue block11;
                            }
                            case PASS_CREDENTIALS: {
                                policy.get("pass-credentials").set(ParseUtils.readBooleanAttributeElement((XMLExtendedStreamReader)reader, (String)"value"));
                                continue block11;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            return policy;
        }

        void parseProperties(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
            while (reader.nextTag() != 2) {
                reader.require(1, Namespace.CURRENT.getUriString(), Element.PROPERTY.getLocalName());
                Property property = ParseUtils.readProperty((XMLExtendedStreamReader)reader);
                node.set(property);
            }
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
            ModelNode node = context.getModelNode();
            if (this.has(node, "connector")) {
                ModelNode connector = node.get("connector");
                for (String name : connector.keys()) {
                    if (!this.has(connector, name)) continue;
                    this.writeConnector(writer, node.get(name), name);
                }
            }
            writer.writeEndElement();
        }

        private void writeConnector(XMLExtendedStreamWriter writer, ModelNode node, String name) throws XMLStreamException {
            writer.writeStartElement(Element.CONNECTOR.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), name);
            if (this.has(node, "socket-binding")) {
                this.writeAttribute(writer, Attribute.SOCKET_BINDING, node.get("socket-binding"));
            }
            if (this.has(node, "authentication-provider")) {
                this.writeSimpleChild(writer, Element.AUTHENTICATION_PROVIDER, Attribute.NAME, node.get("authentication-provider"));
            }
            if (this.has(node, "properties")) {
                this.writeProperties(writer, node.get("properties"));
            }
            if (this.has(node, "sasl")) {
                this.writeSasl(writer, node.get("sasl"));
            }
            writer.writeEndElement();
        }

        private void writeProperties(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
            writer.writeStartElement(Element.PROPERTIES.getLocalName());
            for (String name : node.keys()) {
                ModelNode prop;
                if (!this.has(node, name) || (prop = node.get(name)).getType() != ModelType.PROPERTY) continue;
                writer.writeStartElement(Element.PROPERTY.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), name);
                this.writeAttribute(writer, Attribute.VALUE, prop.asProperty().getValue());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }

        private void writeSasl(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
            writer.writeStartElement(Element.SASL.getLocalName());
            if (this.has(node, "include-mechanisms")) {
                // empty if block
            }
            if (this.has(node, "qop")) {
                this.writeSimpleChild(writer, Element.QOP, Attribute.VALUE, node.get("qop"));
            }
            if (this.has(node, "strength")) {
                this.writeSimpleChild(writer, Element.STRENGTH, Attribute.VALUE, node.get("strength"));
            }
            if (this.has(node, "reuse-session")) {
                this.writeSimpleChild(writer, Element.REUSE_SESSION, Attribute.VALUE, node.get("reuse-session"));
            }
            if (this.has(node, "server-auth")) {
                this.writeSimpleChild(writer, Element.SERVER_AUTH, Attribute.VALUE, node.get("server-auth"));
            }
            if (this.has(node, "policy")) {
                this.writePolicy(writer, node.get("policy"));
            }
            if (this.has(node, "properties")) {
                this.writeProperties(writer, node.get("properties"));
            }
            writer.writeEndElement();
        }

        private void writePolicy(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
            writer.writeStartElement(Element.POLICY.getLocalName());
            if (this.has(node, "forward-secrecy")) {
                this.writeSimpleChild(writer, Element.FORWARD_SECRECY, Attribute.VALUE, node.get("forward-secrecy"));
            }
            if (this.has(node, "no-active")) {
                this.writeSimpleChild(writer, Element.NO_ACTIVE, Attribute.VALUE, node.get("no-active"));
            }
            if (this.has(node, "no-anonymous")) {
                this.writeSimpleChild(writer, Element.NO_ANONYMOUS, Attribute.VALUE, node.get("no-anonymous"));
            }
            if (this.has(node, "no-dictionary")) {
                this.writeSimpleChild(writer, Element.NO_DICTIONARY, Attribute.VALUE, node.get("no-dictionary"));
            }
            if (this.has(node, "no-plaintext")) {
                this.writeSimpleChild(writer, Element.NO_PLAINTEXT, Attribute.VALUE, node.get("no-plaintext"));
            }
            if (this.has(node, "pass-credentials")) {
                this.writeSimpleChild(writer, Element.PASS_CREDENTIALS, Attribute.VALUE, node.get("pass-credentials"));
            }
            writer.writeEndElement();
        }

        private boolean has(ModelNode node, String name) {
            return node.has(name) && node.get(name).isDefined();
        }

        private void writeAttribute(XMLExtendedStreamWriter writer, Attribute attr, ModelNode value) throws XMLStreamException {
            writer.writeAttribute(attr.getLocalName(), value.asString());
        }

        private void writeSimpleChild(XMLExtendedStreamWriter writer, Element element, Attribute attr, ModelNode value) throws XMLStreamException {
            writer.writeStartElement(element.getLocalName());
            this.writeAttribute(writer, attr, value);
            writer.writeEndElement();
        }
    }
}

