/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.remoting.RemotingSubsystemProviders;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Sequence;
import org.xnio.sasl.SaslQop;
import org.xnio.sasl.SaslStrength;

public class ConnectorAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    static final ConnectorAdd INSTANCE = new ConnectorAdd();

    protected void populateModel(ModelNode operation, ModelNode model) {
        model.get("socket-binding").set(operation.require("socket-binding"));
        if (operation.hasDefined("authentication-provider")) {
            model.get("authentication-provider").set(operation.get("authentication-provider"));
        }
        if (operation.hasDefined("sasl")) {
            model.get("sasl").set(operation.get("sasl"));
        }
        if (operation.hasDefined("properties")) {
            model.get("properties").set(operation.get("properties"));
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
    }

    static OptionMap createOptionMap(ModelNode parameters) {
        OptionMap.Builder builder = OptionMap.builder();
        if (parameters.hasDefined("sasl")) {
            ModelNode sasl = parameters.require("sasl");
            builder.set(Options.SASL_SERVER_AUTH, sasl.get("server-auth").asBoolean());
            builder.set(Options.SASL_STRENGTH, (Object)SaslStrength.valueOf((String)sasl.get("strength").asString()));
            builder.set(Options.SASL_QOP, (Object)Sequence.of(ConnectorAdd.asQopSet(sasl.get("qop"))));
            builder.set(Options.SASL_MECHANISMS, (Object)Sequence.of(ConnectorAdd.asStringSet(sasl.get("include-mechanisms"))));
            if (sasl.hasDefined("policy")) {
                ModelNode policy = sasl.require("policy");
                builder.set(Options.SASL_POLICY_FORWARD_SECRECY, policy.get("forward-secrecy").asBoolean());
                builder.set(Options.SASL_POLICY_NOACTIVE, policy.get("no-active").asBoolean());
                builder.set(Options.SASL_POLICY_NOANONYMOUS, policy.get("no-anonymous").asBoolean());
                builder.set(Options.SASL_POLICY_NODICTIONARY, policy.get("no-dictionary").asBoolean());
                builder.set(Options.SASL_POLICY_NOPLAINTEXT, policy.get("no-plaintext").asBoolean());
                builder.set(Options.SASL_POLICY_PASS_CREDENTIALS, policy.get("pass-credentials").asBoolean());
            }
        }
        return builder.getMap();
    }

    static Collection<String> asStringSet(ModelNode node) {
        HashSet<String> set = new HashSet<String>();
        for (ModelNode element : node.asList()) {
            set.add(element.asString());
        }
        return set;
    }

    static Collection<SaslQop> asQopSet(ModelNode node) {
        HashSet<SaslQop> set = new HashSet<SaslQop>();
        for (ModelNode element : node.asList()) {
            set.add(SaslQop.valueOf((String)element.asString()));
        }
        return set;
    }

    public ModelNode getModelDescription(Locale locale) {
        return RemotingSubsystemProviders.CONNECTOR_ADD.getModelDescription(locale);
    }
}

