/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.naming.service;

import java.util.List;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.naming.InMemoryNamingStore;
import org.jboss.as.naming.InitialContextFactoryService;
import org.jboss.as.naming.NamingContext;
import org.jboss.as.naming.NamingEventCoordinator;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.deployment.JndiNamingDependencyProcessor;
import org.jboss.as.naming.deployment.JndiNamingDependencySetupProcessor;
import org.jboss.as.naming.management.JndiViewExtensionRegistry;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.naming.service.NamingStoreService;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class NamingSubsystemAdd
extends AbstractAddStepHandler {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.naming");
    private static final CompositeName EMPTY_NAME = new CompositeName();
    static final NamingSubsystemAdd INSTANCE = new NamingSubsystemAdd();

    protected void populateModel(ModelNode operation, ModelNode model) {
        model.setEmptyObject();
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        log.info((Object)"Activating Naming Subsystem");
        NamingContext.initializeNamingManager();
        InMemoryNamingStore namingStore = new InMemoryNamingStore(new NamingEventCoordinator());
        ServiceTarget target = context.getServiceTarget();
        newControllers.add(target.addService(NamingService.SERVICE_NAME, (Service)new NamingService(namingStore)).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME}).setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)verificationHandler).install());
        final InMemoryNamingStore globalNamingStore = new InMemoryNamingStore();
        newControllers.add(target.addService(ContextNames.GLOBAL_CONTEXT_SERVICE_NAME, (Service)new NamingStoreService(globalNamingStore)).setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)verificationHandler).install());
        final InMemoryNamingStore jbossNamingStore = new InMemoryNamingStore();
        newControllers.add(target.addService(ContextNames.JBOSS_CONTEXT_SERVICE_NAME, (Service)new NamingStoreService(jbossNamingStore)).setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)verificationHandler).install());
        NamespaceContextSelector.setDefault(new NamespaceContextSelector(){

            @Override
            public Context getContext(String identifier) {
                NamingStore namingStore = identifier.equals("global") ? globalNamingStore : (identifier.equals("jboss") ? jbossNamingStore : null);
                if (namingStore != null) {
                    try {
                        return (Context)namingStore.lookup(EMPTY_NAME);
                    }
                    catch (NamingException e) {
                        throw new IllegalStateException(e);
                    }
                }
                return null;
            }
        });
        newControllers.add(InitialContextFactoryService.addService(target, verificationHandler));
        newControllers.add(target.addService(JndiViewExtensionRegistry.SERVICE_NAME, (Service)new JndiViewExtensionRegistry()).install());
        if (context.isBooting()) {
            context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

                protected void execute(DeploymentProcessorTarget processorTarget) {
                    processorTarget.addDeploymentProcessor(Phase.INSTALL, 256, (DeploymentUnitProcessor)new JndiNamingDependencySetupProcessor());
                    processorTarget.addDeploymentProcessor(Phase.INSTALL, 7169, (DeploymentUnitProcessor)new JndiNamingDependencyProcessor());
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }
}

